/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.service;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.switchyard.HandlerException;
import org.switchyard.SwitchYardException;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceInvoker;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceRequest;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceResponse;
import org.switchyard.deploy.ComponentNames;

public class SwitchYardServiceTaskHandler
implements WorkItemHandler {
    private static final Logger LOGGER = Logger.getLogger(SwitchYardServiceTaskHandler.class);
    public static final String SWITCHYARD_SERVICE_TASK = "SwitchYard Service Task";
    public static final String SERVICE_NAME = "ServiceName";
    public static final String OPERATION = "Operation";
    public static final String OPERATION_NAME = "OperationName";
    public static final String PARAMETER_NAME = "ParameterName";
    public static final String RESULT_NAME = "ResultName";
    public static final String FAULT_NAME = "FaultName";
    public static final String FAULT_EVENT_ID = "FaultEventId";
    public static final String FAULT_ACTION = "FaultAction";
    private String _name;
    private QName _componentName;
    private SwitchYardServiceInvoker _invoker;
    private ProcessRuntime _processRuntime;

    public SwitchYardServiceTaskHandler() {
        this.setName(SWITCHYARD_SERVICE_TASK);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public QName getComponentName() {
        return this._componentName;
    }

    public void setComponentName(QName componentName) {
        this._componentName = componentName;
    }

    public SwitchYardServiceInvoker getInvoker() {
        return this._invoker;
    }

    public void setInvoker(SwitchYardServiceInvoker invoker) {
        this._invoker = invoker;
    }

    public ProcessRuntime getProcessRuntime() {
        return this._processRuntime;
    }

    public void setProcessRuntime(ProcessRuntime processRuntime) {
        this._processRuntime = processRuntime;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        QName serviceName;
        Map parameters = workItem.getParameters();
        Object content = null;
        String parameterName = this.getParameterName(parameters);
        if (parameterName != null) {
            content = parameters.get(parameterName);
        }
        if ((serviceName = this.getServiceName(parameters)) != null && this._componentName != null) {
            serviceName = ComponentNames.qualify((QName)this._componentName, (QName)ComponentNames.unqualify((QName)serviceName));
        }
        String operationName = this.getOperationName(parameters);
        SwitchYardServiceRequest request = new SwitchYardServiceRequest(serviceName, operationName, content);
        SwitchYardServiceResponse response = this.getInvoker().invoke(request);
        Map results = workItem.getResults();
        String resultName = this.getResultName(parameters);
        Object fault = response.getFault();
        if (fault == null) {
            if (resultName != null) {
                Object result = response.getContent();
                results.put(resultName, result);
            }
            manager.completeWorkItem(workItem.getId(), results);
        } else {
            String faultEventId;
            String emsg = (fault = this.unwrapFault(fault)) instanceof Throwable ? String.format("Fault encountered [%s(message=%s)]: %s", fault.getClass().getName(), ((Throwable)fault).getMessage(), fault) : String.format("Fault encountered [%s]: %s", fault.getClass().getName(), fault);
            LOGGER.error((Object)emsg);
            String faultName = this.getFaultName(parameters);
            if (faultName != null) {
                results.put(faultName, fault);
            }
            if ((faultEventId = this.getFaultEventId(parameters)) != null) {
                this.getProcessRuntime().signalEvent(faultEventId, fault, workItem.getProcessInstanceId());
            }
            FaultAction faultAction = this.getFaultAction(parameters);
            switch (faultAction) {
                case ABORT: {
                    manager.abortWorkItem(workItem.getId());
                    break;
                }
                case COMPLETE: {
                    manager.completeWorkItem(workItem.getId(), results);
                    break;
                }
                case SKIP: {
                    break;
                }
                case THROW: {
                    RuntimeException runtimeException;
                    if (fault instanceof RuntimeException) {
                        runtimeException = (RuntimeException)fault;
                    } else {
                        Throwable cause;
                        if (fault instanceof Throwable) {
                            cause = (Throwable)fault;
                        } else {
                            cause = new SwitchYardException(emsg);
                            cause.fillInStackTrace();
                        }
                        WorkItemHandlerRuntimeException wihre = new WorkItemHandlerRuntimeException(cause, emsg);
                        wihre.setStackTrace(cause.getStackTrace());
                        wihre.setInformation(SERVICE_NAME, (Object)(serviceName != null ? serviceName.toString() : null));
                        wihre.setInformation(OPERATION_NAME, (Object)operationName);
                        wihre.setInformation(PARAMETER_NAME, (Object)parameterName);
                        wihre.setInformation(RESULT_NAME, (Object)resultName);
                        wihre.setInformation(FAULT_NAME, (Object)faultName);
                        wihre.setInformation(FAULT_EVENT_ID, (Object)faultEventId);
                        wihre.setInformation(FAULT_ACTION, (Object)faultAction.name());
                        wihre.setInformation("workItemHandlerType", (Object)this.getClass().getSimpleName());
                        runtimeException = wihre;
                    }
                    throw runtimeException;
                }
            }
        }
    }

    private Object unwrapFault(Object fault) {
        Throwable cause;
        if (fault instanceof HandlerException && (cause = ((HandlerException)fault).getCause()) != null) {
            return this.unwrapFault(cause);
        }
        if (fault instanceof InvocationTargetException && (cause = ((InvocationTargetException)fault).getCause()) != null) {
            return this.unwrapFault(cause);
        }
        return fault;
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    protected QName getServiceName(Map<String, Object> parameters) {
        return this.getQName(SERVICE_NAME, parameters, null);
    }

    protected String getOperationName(Map<String, Object> parameters) {
        return this.getString(OPERATION_NAME, parameters, null);
    }

    private String getParameterName(Map<String, Object> parameters) {
        return this.getString(PARAMETER_NAME, parameters, "Parameter");
    }

    private String getResultName(Map<String, Object> parameters) {
        return this.getString(RESULT_NAME, parameters, "Result");
    }

    private String getFaultName(Map<String, Object> parameters) {
        return this.getString(FAULT_NAME, parameters, "Fault");
    }

    private String getFaultEventId(Map<String, Object> parameters) {
        return this.getString(FAULT_EVENT_ID, parameters, null);
    }

    private FaultAction getFaultAction(Map<String, Object> parameters) {
        FaultAction faultAction;
        String fa = this.getString(FAULT_ACTION, parameters, FaultAction.DEFAULT.name());
        try {
            faultAction = FaultAction.valueOf(fa.toUpperCase());
        }
        catch (Throwable t) {
            LOGGER.warn((Object)String.format("Unknown %s: %s (%s). Defaulting to %s.", FAULT_ACTION, fa, t.getMessage(), FaultAction.DEFAULT.name()));
            faultAction = FaultAction.DEFAULT;
        }
        return faultAction;
    }

    protected QName getQName(String parameterName, Map<String, Object> parameters, QName defaultValue) {
        Object serviceName = parameters.get(parameterName);
        if (serviceName instanceof QName) {
            return (QName)serviceName;
        }
        if (serviceName instanceof String) {
            return XMLHelper.createQName((String)((String)serviceName));
        }
        return defaultValue;
    }

    protected String getString(String parameterName, Map<String, Object> parameters, String defaultValue) {
        String value = null;
        Object p = parameters.get(parameterName);
        if (p != null) {
            value = Strings.trimToNull((String)String.valueOf(p));
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private static enum FaultAction {
        ABORT,
        COMPLETE,
        SKIP,
        THROW;

        private static final FaultAction DEFAULT;

        static {
            DEFAULT = THROW;
        }
    }
}

