/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.exchange;

import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.xml.namespace.QName;
import org.drools.persistence.jta.JtaTransactionManager;
import org.jbpm.persistence.JpaProcessPersistenceContextManager;
import org.jbpm.persistence.processinstance.JPAProcessInstanceManagerFactory;
import org.jbpm.persistence.processinstance.JPASignalManagerFactory;
import org.jbpm.shared.services.api.JbpmServicesTransactionManager;
import org.jbpm.shared.services.impl.JbpmJTATransactionManager;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.api.task.TaskService;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationAwareProcessRuntime;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.internal.task.api.UserGroupCallback;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.ServiceDomain;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.bpm.BPMConstants;
import org.switchyard.component.bpm.BPMOperationType;
import org.switchyard.component.bpm.config.model.BPMComponentImplementationModel;
import org.switchyard.component.bpm.runtime.BPMProcessEventListener;
import org.switchyard.component.bpm.runtime.BPMRuntimeEnvironment;
import org.switchyard.component.bpm.runtime.BPMRuntimeManager;
import org.switchyard.component.bpm.runtime.BPMTaskService;
import org.switchyard.component.bpm.runtime.BPMTaskServiceRegistry;
import org.switchyard.component.bpm.transaction.AS7TransactionHelper;
import org.switchyard.component.bpm.util.UserGroupCallbacks;
import org.switchyard.component.bpm.util.WorkItemHandlers;
import org.switchyard.component.common.knowledge.OperationType;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.exchange.KnowledgeExchangeHandler;
import org.switchyard.component.common.knowledge.exchange.KnowledgeOperation;
import org.switchyard.component.common.knowledge.session.KnowledgeSession;
import org.switchyard.component.common.knowledge.util.Disposals;
import org.switchyard.component.common.knowledge.util.Environments;
import org.switchyard.component.common.knowledge.util.Listeners;
import org.switchyard.component.common.knowledge.util.Operations;

public class BPMExchangeHandler
extends KnowledgeExchangeHandler<BPMComponentImplementationModel> {
    private static final KnowledgeOperation DEFAULT_OPERATION = new KnowledgeOperation((OperationType)BPMOperationType.START_PROCESS);
    private final boolean _persistent;
    private final String _processId;
    private BPMProcessEventListener _processEventListener;
    private UserGroupCallback _userGroupCallback;
    private CorrelationKeyFactory _correlationKeyFactory;
    private EntityManagerFactory _processEntityManagerFactory;
    private EntityManagerFactory _taskEntityManagerFactory;
    private BPMTaskService _taskService;

    public BPMExchangeHandler(BPMComponentImplementationModel model, ServiceDomain serviceDomain, QName serviceName) {
        super((KnowledgeComponentImplementationModel)model, serviceDomain, serviceName);
        this._persistent = model.isPersistent();
        this._processId = model.getProcessId();
    }

    protected void doStart() {
        super.doStart();
        this._processEventListener = new BPMProcessEventListener(this.getServiceDomain().getEventPublisher());
        this._userGroupCallback = UserGroupCallbacks.newUserGroupCallback((BPMComponentImplementationModel)this.getModel(), this.getLoader());
        this._correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
        if (this._persistent) {
            this._processEntityManagerFactory = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
            this._taskEntityManagerFactory = Persistence.createEntityManagerFactory((String)"org.jbpm.services.task");
            this._taskService = BPMTaskService.Factory.newTaskService(Environments.getEnvironment((Map)super.getEnvironmentOverrides()), this._taskEntityManagerFactory, (JbpmServicesTransactionManager)new JbpmJTATransactionManager(), this._userGroupCallback, this.getLoader());
            BPMTaskServiceRegistry.putTaskService(this.getServiceDomain().getName(), this.getServiceName(), this._taskService);
        }
    }

    protected void doStop() {
        super.doStop();
        this._processEventListener = null;
        this._userGroupCallback = null;
        this._correlationKeyFactory = null;
        if (this._processEntityManagerFactory != null) {
            Disposals.newDisposal((EntityManagerFactory)this._processEntityManagerFactory).dispose();
            this._processEntityManagerFactory = null;
        }
        if (this._taskEntityManagerFactory != null) {
            Disposals.newDisposal((EntityManagerFactory)this._taskEntityManagerFactory).dispose();
            this._taskEntityManagerFactory = null;
        }
        this._taskService = null;
        BPMTaskServiceRegistry.removeTaskService(this.getServiceDomain().getName(), this.getServiceName());
    }

    protected Properties getPropertyOverrides() {
        Properties props = super.getPropertyOverrides();
        if (this._persistent) {
            props.setProperty("drools.processInstanceManagerFactory", JPAProcessInstanceManagerFactory.class.getName());
            props.setProperty("drools.processSignalManagerFactory", JPASignalManagerFactory.class.getName());
        }
        return props;
    }

    protected Map<String, Object> getEnvironmentOverrides() {
        Map env = super.getEnvironmentOverrides();
        if (this._persistent) {
            UserTransaction ut = AS7TransactionHelper.getUserTransaction();
            TransactionManager tm = AS7TransactionHelper.getTransactionManager();
            env.put("org.kie.api.persistence.jpa.EntityManagerFactory", this._processEntityManagerFactory);
            env.put("org.kie.transaction.Transaction", ut);
            env.put("org.kie.transaction.TransactionManager", new JtaTransactionManager((Object)ut, null, (Object)tm));
            env.put("org.kie.api.persistence.PersistenceContextManager", new JpaProcessPersistenceContextManager(Environments.getEnvironment((Map)env)));
        }
        return env;
    }

    public KnowledgeOperation getDefaultOperation() {
        return DEFAULT_OPERATION;
    }

    public void handleOperation(Exchange exchange, KnowledgeOperation operation) throws HandlerException {
        Integer sessionId = null;
        Long processInstanceId = null;
        Message inputMessage = exchange.getMessage();
        ExchangePattern exchangePattern = exchange.getContract().getProviderOperation().getExchangePattern();
        HashMap<String, Object> expressionContext = new HashMap<String, Object>();
        AS7TransactionHelper utx = new AS7TransactionHelper(this._persistent);
        BPMOperationType operationType = (BPMOperationType)operation.getType();
        switch (operationType) {
            case START_PROCESS: {
                KnowledgeSession session;
                try {
                    utx.begin();
                    session = this.getBPMSession(exchange, inputMessage);
                    sessionId = session.getId();
                    Operations.setGlobals((Message)inputMessage, (KnowledgeOperation)operation, (KnowledgeSession)session);
                    Map inputMap = Operations.getInputMap((Message)inputMessage, (KnowledgeOperation)operation);
                    CorrelationKey correlationKey = this.getCorrelationKey(exchange, inputMessage);
                    ProcessInstance processInstance = correlationKey != null ? ((CorrelationAwareProcessRuntime)session.getStateful()).startProcess(this._processId, correlationKey, inputMap) : session.getStateful().startProcess(this._processId, inputMap);
                    processInstanceId = processInstance.getId();
                    if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                        expressionContext.putAll(this.getGlobalVariables(session));
                        expressionContext.putAll(this.getProcessInstanceVariables(processInstance));
                    }
                    utx.commit();
                    break;
                }
                catch (RuntimeException re) {
                    utx.rollback();
                    throw re;
                }
            }
            case SIGNAL_EVENT: 
            case SIGNAL_EVENT_ALL: {
                KnowledgeSession session;
                try {
                    utx.begin();
                    session = this.getBPMSession(exchange, inputMessage);
                    sessionId = session.getId();
                    Operations.setGlobals((Message)inputMessage, (KnowledgeOperation)operation, (KnowledgeSession)session);
                    Object eventObject = Operations.getInput((Message)inputMessage, (KnowledgeOperation)operation);
                    String eventId = operation.getEventId();
                    if (BPMOperationType.SIGNAL_EVENT.equals((Object)operationType)) {
                        processInstanceId = this.getProcessInstanceId(exchange, inputMessage, session);
                        if (processInstanceId == null) {
                            throw new HandlerException("Cannot signalEvent: unknown processInstanceId or unknown/unmatched correlationKey");
                        }
                        session.getStateful().signalEvent(eventId, eventObject, processInstanceId.longValue());
                        if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                            expressionContext.putAll(this.getGlobalVariables(session));
                            ProcessInstance processInstance = session.getStateful().getProcessInstance(processInstanceId.longValue());
                            expressionContext.putAll(this.getProcessInstanceVariables(processInstance));
                        }
                    } else if (BPMOperationType.SIGNAL_EVENT_ALL.equals((Object)operationType)) {
                        session.getStateful().signalEvent(eventId, eventObject);
                        if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                            expressionContext.putAll(this.getGlobalVariables(session));
                        }
                    }
                    utx.commit();
                    break;
                }
                catch (RuntimeException re) {
                    utx.rollback();
                    throw re;
                }
            }
            case ABORT_PROCESS_INSTANCE: {
                KnowledgeSession session;
                try {
                    utx.begin();
                    session = this.getBPMSession(exchange, inputMessage);
                    sessionId = session.getId();
                    processInstanceId = this.getProcessInstanceId(exchange, inputMessage, session);
                    if (processInstanceId == null) {
                        throw new HandlerException("Cannot abortProcessInstance: unknown processInstanceId or unknown/unmatched correlationKey");
                    }
                    if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                        expressionContext.putAll(this.getGlobalVariables(session));
                        ProcessInstance processInstance = session.getStateful().getProcessInstance(processInstanceId.longValue());
                        expressionContext.putAll(this.getProcessInstanceVariables(processInstance));
                    }
                    session.getStateful().abortProcessInstance(processInstanceId.longValue());
                    utx.commit();
                    break;
                }
                catch (RuntimeException re) {
                    utx.rollback();
                    throw re;
                }
            }
            default: {
                throw new HandlerException("Unsupported operation type: " + (Object)((Object)operationType));
            }
        }
        if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
            Message outputMessage = exchange.createMessage();
            Context outputContext = exchange.getContext(outputMessage);
            if (sessionId != null && sessionId > 0) {
                outputContext.setProperty(BPMConstants.SESSION_ID_PROPERTY, (Object)sessionId);
            }
            if (processInstanceId != null && processInstanceId > 0L) {
                outputContext.setProperty(BPMConstants.PROCESSS_INSTANCE_ID_PROPERTY, (Object)processInstanceId);
            }
            Operations.setFaults((Message)outputMessage, (KnowledgeOperation)operation, expressionContext);
            if (outputMessage.getContent() != null) {
                exchange.sendFault(outputMessage);
            } else {
                Operations.setOutputs((Message)outputMessage, (KnowledgeOperation)operation, expressionContext);
                exchange.send(outputMessage);
            }
        }
    }

    private KnowledgeSession getBPMSession(Exchange exchange, Message message) {
        KnowledgeSession session = this._persistent ? this.getPersistentSession(this.getSessionId(exchange, message)) : this.getStatefulSession();
        Listeners.registerListener((EventListener)((Object)this._processEventListener), (KieRuntimeEventManager)session.getStateful());
        BPMRuntimeEnvironment runtimeEnvironment = new BPMRuntimeEnvironment(session.getStateful(), this._processEntityManagerFactory, this._userGroupCallback, this.getLoader());
        BPMRuntimeManager runtimeManager = new BPMRuntimeManager(session.getStateful(), (TaskService)this._taskService, this.getDeploymentId(), runtimeEnvironment);
        WorkItemHandlers.registerWorkItemHandlers((BPMComponentImplementationModel)this.getModel(), this.getLoader(), (ProcessRuntime)session.getStateful(), runtimeManager, this.getServiceDomain());
        return session;
    }

    private CorrelationKey getCorrelationKey(Exchange exchange, Message message) {
        List properties;
        String ckp = this.getString(exchange, message, BPMConstants.CORRELATION_KEY_PROPERTY);
        if (ckp != null && (properties = Strings.splitTrimToNull((String)ckp, (String)" \t\n\r\f")).size() > 0) {
            return this._correlationKeyFactory.newCorrelationKey(properties);
        }
        return null;
    }

    private Integer getSessionId(Exchange exchange, Message message) {
        return this.getInteger(exchange, message, BPMConstants.SESSION_ID_PROPERTY);
    }

    private Long getProcessInstanceId(Exchange exchange, Message message) {
        return this.getLong(exchange, message, BPMConstants.PROCESSS_INSTANCE_ID_PROPERTY);
    }

    private Long getProcessInstanceId(Exchange exchange, Message message, KnowledgeSession session) {
        CorrelationKey correlationKey;
        Long processInstanceId = this.getProcessInstanceId(exchange, message);
        if (processInstanceId == null && (correlationKey = this.getCorrelationKey(exchange, message)) != null) {
            processInstanceId = this.getProcessInstanceId(correlationKey, session);
        }
        return processInstanceId;
    }

    private Long getProcessInstanceId(CorrelationKey correlationKey, KnowledgeSession session) {
        ProcessInstance processInstance;
        if (correlationKey != null && (processInstance = ((CorrelationAwareProcessRuntime)session.getStateful()).getProcessInstance(correlationKey)) != null) {
            return processInstance.getId();
        }
        return null;
    }

    private Map<String, Object> getProcessInstanceVariables(ProcessInstance processInstance) {
        Map var;
        HashMap<String, Object> processInstanceVariables = new HashMap<String, Object>();
        if (processInstance instanceof WorkflowProcessInstanceImpl && (var = ((WorkflowProcessInstanceImpl)processInstance).getVariables()) != null) {
            processInstanceVariables.putAll(var);
        }
        return processInstanceVariables;
    }
}

