/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.util;

import java.lang.reflect.Constructor;
import java.util.Properties;
import org.kie.internal.task.api.UserGroupCallback;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.component.bpm.BPMMessages;
import org.switchyard.component.bpm.config.model.BPMComponentImplementationModel;
import org.switchyard.component.bpm.config.model.UserGroupCallbackModel;
import org.switchyard.component.bpm.runtime.BPMUserGroupCallback;
import org.switchyard.config.model.property.PropertiesModel;

public final class UserGroupCallbacks {
    private static final Class<?>[][] PARAMETER_TYPES = new Class[][]{{Properties.class}, new Class[0]};

    public static UserGroupCallback newUserGroupCallback(BPMComponentImplementationModel model, ClassLoader loader) {
        Class<?> userGroupCallbackClass = null;
        Properties properties = null;
        UserGroupCallbackModel userGroupCallbackModel = model.getUserGroupCallback();
        if (userGroupCallbackModel != null) {
            userGroupCallbackClass = userGroupCallbackModel.getClazz(loader);
            PropertiesModel propertiesModel = userGroupCallbackModel.getProperties();
            Properties properties2 = properties = propertiesModel != null ? propertiesModel.toProperties() : null;
        }
        if (properties == null) {
            properties = new Properties();
        }
        if (userGroupCallbackClass != null) {
            return UserGroupCallbacks.newUserGroupCallback(userGroupCallbackClass, properties);
        }
        if (properties.size() > 0) {
            return new BPMUserGroupCallback(properties);
        }
        return new BPMUserGroupCallback();
    }

    public static UserGroupCallback newUserGroupCallback(Class<? extends UserGroupCallback> userGroupCallbackClass, Properties properties) {
        UserGroupCallback userGroupCallback = null;
        Constructor<? extends UserGroupCallback> constructor = UserGroupCallbacks.getConstructor(userGroupCallbackClass);
        Class[] parameterTypes = constructor != null ? constructor.getParameterTypes() : new Class[]{};
        try {
            if (parameterTypes.length == 0) {
                userGroupCallback = (UserGroupCallback)Construction.construct(userGroupCallbackClass);
            } else if (parameterTypes.length == 1) {
                userGroupCallback = (UserGroupCallback)Construction.construct(userGroupCallbackClass, (Class[])parameterTypes, (Object[])new Object[]{properties});
            }
        }
        catch (Throwable t) {
            throw BPMMessages.MESSAGES.couldNotInstantiateUserGroupCallbackClass(userGroupCallbackClass.getName());
        }
        return userGroupCallback;
    }

    private static Constructor<? extends UserGroupCallback> getConstructor(Class<? extends UserGroupCallback> userGroupCallbackClass) {
        Constructor<? extends UserGroupCallback> constructor = null;
        for (Class<?>[] parameterTypes : PARAMETER_TYPES) {
            try {
                constructor = userGroupCallbackClass.getConstructor(parameterTypes);
                if (constructor == null) continue;
                break;
            }
            catch (Throwable t) {
                t.getMessage();
            }
        }
        return constructor;
    }

    private UserGroupCallbacks() {
    }
}

