/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.service;

import java.util.Map;
import javax.xml.namespace.QName;
import org.jbpm.process.workitem.bpmn2.ServiceTaskHandler;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.switchyard.component.bpm.service.SwitchYardServiceTaskHandler;

public class StandardSwitchYardServiceTaskHandler
extends SwitchYardServiceTaskHandler {
    public static final String SERVICE_TASK = "Service Task";
    public static final String IMPLEMENTATION = "implementation";
    public static final String IMPLEMENTATION_SWITCHYARD = "##SwitchYard";
    public static final String INTERFACE = "Interface";
    public static final String INTERFACE_IMPLEMENTATION_REF = "interfaceImplementationRef";
    public static final String OPERATION_IMPLEMENTATION_REF = "operationImplementationRef";

    public StandardSwitchYardServiceTaskHandler() {
        this.setName(SERVICE_TASK);
    }

    @Override
    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        String implementation = this.getImplementation(workItem.getParameters());
        if (IMPLEMENTATION_SWITCHYARD.equalsIgnoreCase(implementation)) {
            super.executeWorkItem(workItem, manager);
        } else {
            ProcessRuntime runtime = this.getProcessRuntime();
            ServiceTaskHandler sth = runtime instanceof KieSession ? new ServiceTaskHandler((KieSession)runtime) : new ServiceTaskHandler();
            sth.setClassLoader(this.getClass().getClassLoader());
            sth.executeWorkItem(workItem, manager);
        }
    }

    private String getImplementation(Map<String, Object> parameters) {
        return this.getString(IMPLEMENTATION, parameters, null);
    }

    @Override
    protected QName getServiceName(Map<String, Object> parameters) {
        return this.getQName(INTERFACE, parameters, this.getQName(INTERFACE_IMPLEMENTATION_REF, parameters, null));
    }

    @Override
    protected String getOperationName(Map<String, Object> parameters) {
        return this.getString("Operation", parameters, this.getString(OPERATION_IMPLEMENTATION_REF, parameters, null));
    }
}

