/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.component.bpm.runtime.BPMTaskService;
import org.switchyard.deploy.ServiceDomainManager;

public final class BPMTaskServiceRegistry {
    private static final Map<QName, Map<QName, BPMTaskService>> REGISTRY = Collections.synchronizedMap(new HashMap());

    public static final synchronized BPMTaskService getTaskService(QName serviceDomainName, QName serviceName) {
        Map<QName, BPMTaskService> reg;
        if (serviceDomainName == null) {
            serviceDomainName = ServiceDomainManager.ROOT_DOMAIN;
        }
        return (reg = REGISTRY.get(serviceDomainName)) != null ? reg.get(serviceName) : null;
    }

    public static final synchronized void putTaskService(QName serviceDomainName, QName serviceName, BPMTaskService taskService) {
        Map<QName, BPMTaskService> reg;
        if (serviceDomainName == null) {
            serviceDomainName = ServiceDomainManager.ROOT_DOMAIN;
        }
        if ((reg = REGISTRY.get(serviceDomainName)) == null) {
            reg = Collections.synchronizedMap(new HashMap());
            REGISTRY.put(serviceDomainName, reg);
        }
        if (taskService == null) {
            reg.remove(serviceName);
        } else {
            reg.put(serviceName, taskService);
        }
    }

    public static final synchronized void removeTaskService(QName serviceDomainName, QName serviceName) {
        BPMTaskServiceRegistry.putTaskService(serviceDomainName, serviceName, null);
    }

    private BPMTaskServiceRegistry() {
    }
}

