/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.config.model;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import org.jbpm.services.task.wih.AbstractHTWorkItemHandler;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.classpath.ClasspathScanner;
import org.switchyard.common.type.classpath.Filter;
import org.switchyard.common.type.classpath.IsAnnotationPresentFilter;
import org.switchyard.component.bpm.BPMMessages;
import org.switchyard.component.bpm.BPMOperationType;
import org.switchyard.component.bpm.annotation.AbortProcessInstance;
import org.switchyard.component.bpm.annotation.BPM;
import org.switchyard.component.bpm.annotation.SignalEvent;
import org.switchyard.component.bpm.annotation.SignalEventAll;
import org.switchyard.component.bpm.annotation.StartProcess;
import org.switchyard.component.bpm.annotation.UserGroupCallback;
import org.switchyard.component.bpm.annotation.WorkItemHandler;
import org.switchyard.component.bpm.config.model.BPMNamespace;
import org.switchyard.component.bpm.config.model.UserGroupCallbackModel;
import org.switchyard.component.bpm.config.model.WorkItemHandlersModel;
import org.switchyard.component.bpm.config.model.v1.V1BPMComponentImplementationModel;
import org.switchyard.component.bpm.config.model.v1.V1BPMOperationModel;
import org.switchyard.component.bpm.config.model.v1.V1UserGroupCallbackModel;
import org.switchyard.component.bpm.config.model.v1.V1WorkItemHandlerModel;
import org.switchyard.component.bpm.config.model.v1.V1WorkItemHandlersModel;
import org.switchyard.component.bpm.service.SwitchYardServiceTaskHandler;
import org.switchyard.component.bpm.util.WorkItemHandlers;
import org.switchyard.component.common.knowledge.annotation.Fault;
import org.switchyard.component.common.knowledge.annotation.Global;
import org.switchyard.component.common.knowledge.annotation.Input;
import org.switchyard.component.common.knowledge.annotation.Output;
import org.switchyard.component.common.knowledge.config.model.KnowledgeSwitchYardScanner;
import org.switchyard.component.common.knowledge.config.model.OperationModel;
import org.switchyard.component.common.knowledge.config.model.OperationsModel;
import org.switchyard.component.common.knowledge.config.model.v1.V1OperationsModel;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.Namespace;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.ScannerOutput;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.config.model.composite.v1.V1ComponentModel;
import org.switchyard.config.model.composite.v1.V1ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1CompositeModel;
import org.switchyard.config.model.composite.v1.V1InterfaceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.switchyard.SwitchYardNamespace;
import org.switchyard.config.model.switchyard.v1.V1SwitchYardModel;
import org.switchyard.extensions.java.JavaService;
import org.switchyard.metadata.ServiceOperation;

public class BPMSwitchYardScanner
extends KnowledgeSwitchYardScanner {
    private static final IsAnnotationPresentFilter START_PROCESS_FILTER = new IsAnnotationPresentFilter(StartProcess.class);
    private static final IsAnnotationPresentFilter SIGNAL_EVENT_FILTER = new IsAnnotationPresentFilter(SignalEvent.class);
    private static final IsAnnotationPresentFilter SIGNAL_EVENT_ALL_FILTER = new IsAnnotationPresentFilter(SignalEventAll.class);
    private static final IsAnnotationPresentFilter ABORT_PROCESS_INSTANCE_FILTER = new IsAnnotationPresentFilter(AbortProcessInstance.class);
    private final IsAnnotationPresentFilter _bpmFilter = new IsAnnotationPresentFilter(BPM.class);

    public ScannerOutput<SwitchYardModel> scan(ScannerInput<SwitchYardModel> input) throws IOException {
        SwitchYardNamespace switchyardNamespace = input.getSwitchyardNamespace();
        V1SwitchYardModel switchyardModel = new V1SwitchYardModel(switchyardNamespace.uri());
        V1CompositeModel compositeModel = new V1CompositeModel();
        compositeModel.setName(input.getCompositeName());
        ClasspathScanner bpmScanner = new ClasspathScanner((Filter)this._bpmFilter);
        for (URL url : input.getURLs()) {
            bpmScanner.scan(url);
        }
        List bpmClasses = this._bpmFilter.getMatchedTypes();
        for (Class bpmClass : bpmClasses) {
            compositeModel.addComponent(this.scan(bpmClass, switchyardNamespace));
        }
        if (!compositeModel.getModelChildren().isEmpty()) {
            switchyardModel.setComposite((CompositeModel)compositeModel);
        }
        return new ScannerOutput().setModel((Model)switchyardModel);
    }

    public ComponentModel scan(Class<?> bpmClass) throws IOException {
        return this.scan(bpmClass, null);
    }

    public ComponentModel scan(Class<?> bpmClass, SwitchYardNamespace switchyardNamespace) throws IOException {
        String processId;
        BPM bpm;
        if (switchyardNamespace == null) {
            switchyardNamespace = SwitchYardNamespace.DEFAULT;
        }
        if ((bpm = bpmClass.getAnnotation(BPM.class)) == null) {
            throw BPMMessages.MESSAGES.bpmClassGetNameIsMissingTheBPMAnnotation(bpmClass.getName());
        }
        Class<?> bpmInterface = bpm.value();
        if (BPM.UndefinedBPMInterface.class.equals(bpmInterface)) {
            bpmInterface = bpmClass;
        }
        if (!bpmInterface.isInterface()) {
            throw BPMMessages.MESSAGES.bpmInterfaceGetNameIsAClassBPMOnlyAllowedOnInterfaces(bpmInterface.getName());
        }
        String bpmName = Strings.trimToNull((String)bpm.name());
        if (bpmName == null) {
            bpmName = bpmInterface.getSimpleName();
        }
        V1ComponentModel componentModel = new V1ComponentModel();
        componentModel.setName(bpmName);
        BPMNamespace bpmNamespace = BPMNamespace.fromUri(bpm.namespace());
        if (bpmNamespace == null) {
            bpmNamespace = BPMNamespace.DEFAULT;
            for (BPMNamespace value : BPMNamespace.values()) {
                if (!value.versionMatches((Namespace)switchyardNamespace)) continue;
                bpmNamespace = value;
                break;
            }
        }
        V1BPMComponentImplementationModel componentImplementationModel = new V1BPMComponentImplementationModel(bpmNamespace.uri());
        boolean persistent = bpm.persistent();
        if (persistent) {
            componentImplementationModel.setPersistent(persistent);
        }
        if ("".equals(processId = bpm.processId())) {
            processId = bpmName;
        }
        componentImplementationModel.setProcessId(processId);
        V1OperationsModel operationsModel = new V1OperationsModel(bpmNamespace.uri());
        JavaService javaService = JavaService.fromClass(bpmInterface);
        for (Method method : bpmClass.getDeclaredMethods()) {
            ServiceOperation serviceOperation;
            BPMOperationType operationType = null;
            String eventId = null;
            Global[] globalMappingAnnotations = null;
            Input[] inputMappingAnnotations = null;
            Output[] outputMappingAnnotations = null;
            Fault[] faultMappingAnnotations = null;
            if (START_PROCESS_FILTER.matches(method)) {
                operationType = BPMOperationType.START_PROCESS;
                StartProcess startProcessAnnotation = method.getAnnotation(StartProcess.class);
                globalMappingAnnotations = startProcessAnnotation.globals();
                inputMappingAnnotations = startProcessAnnotation.inputs();
                outputMappingAnnotations = startProcessAnnotation.outputs();
                faultMappingAnnotations = startProcessAnnotation.faults();
            } else if (SIGNAL_EVENT_FILTER.matches(method)) {
                operationType = BPMOperationType.SIGNAL_EVENT;
                SignalEvent signalEventAnnotation = method.getAnnotation(SignalEvent.class);
                eventId = Strings.trimToNull((String)signalEventAnnotation.eventId());
                globalMappingAnnotations = signalEventAnnotation.globals();
                inputMappingAnnotations = signalEventAnnotation.inputs();
                outputMappingAnnotations = signalEventAnnotation.outputs();
                faultMappingAnnotations = signalEventAnnotation.faults();
            } else if (SIGNAL_EVENT_ALL_FILTER.matches(method)) {
                operationType = BPMOperationType.SIGNAL_EVENT_ALL;
                SignalEventAll signalEventAllAnnotation = method.getAnnotation(SignalEventAll.class);
                eventId = Strings.trimToNull((String)signalEventAllAnnotation.eventId());
                globalMappingAnnotations = signalEventAllAnnotation.globals();
                inputMappingAnnotations = signalEventAllAnnotation.inputs();
                outputMappingAnnotations = signalEventAllAnnotation.outputs();
                faultMappingAnnotations = signalEventAllAnnotation.faults();
            } else if (ABORT_PROCESS_INSTANCE_FILTER.matches(method)) {
                operationType = BPMOperationType.ABORT_PROCESS_INSTANCE;
                AbortProcessInstance abortProcessInstanceAnnotation = method.getAnnotation(AbortProcessInstance.class);
                globalMappingAnnotations = new Global[]{};
                inputMappingAnnotations = new Input[]{};
                outputMappingAnnotations = abortProcessInstanceAnnotation.outputs();
                faultMappingAnnotations = abortProcessInstanceAnnotation.faults();
            }
            if (operationType == null || (serviceOperation = javaService.getOperation(method.getName())) == null) continue;
            V1BPMOperationModel operationModel = new V1BPMOperationModel(bpmNamespace.uri());
            operationModel.setEventId(eventId);
            operationModel.setName(serviceOperation.getName());
            operationModel.setType(operationType);
            operationModel.setGlobals(this.toGlobalsModel(globalMappingAnnotations, bpmNamespace));
            operationModel.setInputs(this.toInputsModel(inputMappingAnnotations, bpmNamespace));
            operationModel.setOutputs(this.toOutputsModel(outputMappingAnnotations, bpmNamespace));
            operationModel.setFaults(this.toFaultsModel(faultMappingAnnotations, bpmNamespace));
            operationsModel.addOperation((OperationModel)operationModel);
        }
        if (!operationsModel.getOperations().isEmpty()) {
            componentImplementationModel.setOperations((OperationsModel)operationsModel);
        }
        componentImplementationModel.setChannels(this.toChannelsModel(bpm.channels(), bpmNamespace, (ComponentModel)componentModel, switchyardNamespace));
        componentImplementationModel.setListeners(this.toListenersModel(bpm.listeners(), bpmNamespace));
        componentImplementationModel.setLoggers(this.toLoggersModel(bpm.loggers(), bpmNamespace));
        componentImplementationModel.setManifest(this.toManifestModel(bpm.manifest(), bpmNamespace));
        componentImplementationModel.setProperties(this.toPropertiesModel(bpm.properties(), bpmNamespace));
        componentImplementationModel.setUserGroupCallback(this.toUserGroupCallbackModel(bpm.userGroupCallback(), bpmNamespace));
        componentImplementationModel.setWorkItemHandlers(this.toWorkItemHandlersModel(bpm.workItemHandlers(), bpmNamespace));
        componentModel.setImplementation((ComponentImplementationModel)componentImplementationModel);
        V1ComponentServiceModel componentServiceModel = new V1ComponentServiceModel(switchyardNamespace.uri());
        V1InterfaceModel interfaceModel = new V1InterfaceModel("java");
        interfaceModel.setInterface(bpmInterface.getName());
        componentServiceModel.setInterface((InterfaceModel)interfaceModel);
        componentServiceModel.setName(bpmName);
        componentModel.addService((ComponentServiceModel)componentServiceModel);
        return componentModel;
    }

    private UserGroupCallbackModel toUserGroupCallbackModel(UserGroupCallback[] userGroupCallbackAnnotations, BPMNamespace bpmNamespace) {
        V1UserGroupCallbackModel userGroupCallbackModel;
        block1: {
            if (userGroupCallbackAnnotations == null || userGroupCallbackAnnotations.length == 0) {
                return null;
            }
            userGroupCallbackModel = null;
            int i$ = 0;
            UserGroupCallback[] arr$ = userGroupCallbackAnnotations;
            int len$ = arr$.length;
            if (i$ >= len$) break block1;
            UserGroupCallback userGroupCallbackAnnotation = arr$[i$];
            userGroupCallbackModel = new V1UserGroupCallbackModel(bpmNamespace.uri());
            Class<? extends org.kie.internal.task.api.UserGroupCallback> clazz = userGroupCallbackAnnotation.value();
            userGroupCallbackModel.setClazz(clazz);
            userGroupCallbackModel.setProperties(this.toPropertiesModel(userGroupCallbackAnnotation.properties(), bpmNamespace));
        }
        return userGroupCallbackModel;
    }

    private WorkItemHandlersModel toWorkItemHandlersModel(WorkItemHandler[] workItemHandlerAnnotations, BPMNamespace bpmNamespace) {
        if (workItemHandlerAnnotations == null || workItemHandlerAnnotations.length == 0) {
            return null;
        }
        V1WorkItemHandlersModel workItemHandlersModel = new V1WorkItemHandlersModel(bpmNamespace.uri());
        for (WorkItemHandler workItemHandlerAnnotation : workItemHandlerAnnotations) {
            V1WorkItemHandlerModel workItemHandlerModel = new V1WorkItemHandlerModel(bpmNamespace.uri());
            Class<? extends org.kie.api.runtime.process.WorkItemHandler> clazz = workItemHandlerAnnotation.value();
            workItemHandlerModel.setClazz(clazz);
            String name = workItemHandlerAnnotation.name();
            if ("".equals(name)) {
                org.kie.api.runtime.process.WorkItemHandler wih = WorkItemHandlers.newWorkItemHandler(clazz, null, null);
                if (wih instanceof SwitchYardServiceTaskHandler) {
                    SwitchYardServiceTaskHandler ssth = (SwitchYardServiceTaskHandler)wih;
                    if (ssth.getName() != null) {
                        name = ssth.getName();
                    }
                } else if (wih instanceof AbstractHTWorkItemHandler) {
                    name = "Human Task";
                }
            }
            if ("".equals(name)) {
                name = clazz.getSimpleName();
            }
            workItemHandlerModel.setName(name);
            workItemHandlersModel.addWorkItemHandler(workItemHandlerModel);
        }
        return workItemHandlersModel;
    }
}

