/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.task.impl;

import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.log4j.Logger;
import org.jbpm.task.Group;
import org.jbpm.task.User;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.TaskServiceSession;
import org.jbpm.task.service.mina.MinaTaskServer;
import org.kie.SystemEventListenerFactory;
import org.switchyard.component.bpm.task.BaseTaskServer;
import org.switchyard.exception.SwitchYardException;

public class TaskServerImpl
extends BaseTaskServer {
    private static final Logger LOGGER = Logger.getLogger(TaskServerImpl.class);
    private TaskServer _wrapped = null;

    @Override
    public void start() {
        LOGGER.info((Object)String.format("Starting jBPM TaskServer on %s:%s...", this.getHost(), this.getPort()));
        this.waitForPort(true);
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.jbpm.task");
        TaskService taskService = new TaskService(emf, SystemEventListenerFactory.getSystemEventListener());
        TaskServiceSession taskServiceSession = taskService.createSession();
        Set<String> userIds = this.addUsers(taskServiceSession);
        this.addGroups(taskServiceSession, userIds);
        taskServiceSession.dispose();
        this._wrapped = new MinaTaskServer(taskService, this.getPort(), this.getHost());
        new Thread((Runnable)this._wrapped).start();
        this.setStarted(this.waitForPort(false));
        if (this.isStarted()) {
            LOGGER.info((Object)String.format("jBPM TaskServer started on %s:%s.", this.getHost(), this.getPort()));
        } else {
            LOGGER.warn((Object)String.format("jBPM TaskServer started on %s, but port %s is not yet ready.", this.getHost(), this.getPort()));
        }
    }

    private Set<String> addUsers(TaskServiceSession taskServiceSession) {
        Set<String> usersSet = this.getUsersSet("Administrator");
        for (String user : usersSet) {
            try {
                taskServiceSession.addUser(new User(user));
            }
            catch (Throwable t) {
                LOGGER.warn((Object)t.getMessage());
            }
        }
        return usersSet;
    }

    private void addGroups(TaskServiceSession taskServiceSession, Set<String> usersSet) {
        Set<String> groupsSet = this.getGroupsSet(new String[0]);
        for (String group : groupsSet) {
            if (usersSet.contains(group)) continue;
            try {
                taskServiceSession.addGroup(new Group(group));
            }
            catch (Throwable t) {
                LOGGER.warn((Object)t.getMessage());
            }
        }
    }

    @Override
    public void stop() {
        LOGGER.info((Object)String.format("Stopping jBPM TaskServer on %s:%s...", this.getHost(), this.getPort()));
        if (this._wrapped != null) {
            try {
                this._wrapped.stop();
            }
            catch (Exception e) {
                throw new SwitchYardException((Throwable)e);
            }
            finally {
                this._wrapped = null;
            }
        }
        this.waitForPort(true);
        this.setStarted(false);
        LOGGER.info((Object)String.format("jBPM TaskServer on %s:%s stopped.", this.getHost(), this.getPort()));
    }
}

