/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.service;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.kie.runtime.process.ProcessRuntime;
import org.kie.runtime.process.WorkItem;
import org.kie.runtime.process.WorkItemHandler;
import org.kie.runtime.process.WorkItemManager;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceInvoker;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceRequest;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceResponse;

public class SwitchYardServiceTaskHandler
implements WorkItemHandler {
    private static final Logger LOGGER = Logger.getLogger(SwitchYardServiceTaskHandler.class);
    public static final String SWITCHYARD_SERVICE_TASK = "SwitchYard Service Task";
    public static final String SERVICE_NAME = "ServiceName";
    public static final String OPERATION = "Operation";
    public static final String OPERATION_NAME = "OperationName";
    public static final String PARAMETER_NAME = "ParameterName";
    public static final String RESULT_NAME = "ResultName";
    public static final String FAULT_RESULT_NAME = "FaultResultName";
    public static final String FAULT_EVENT_ID = "FaultEventId";
    public static final String FAULT_WORK_ITEM_ACTION = "FaultWorkItemAction";
    private String _name;
    private SwitchYardServiceInvoker _invoker;
    private ProcessRuntime _processRuntime;

    public SwitchYardServiceTaskHandler() {
        this.setName(SWITCHYARD_SERVICE_TASK);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public SwitchYardServiceInvoker getInvoker() {
        return this._invoker;
    }

    public void setInvoker(SwitchYardServiceInvoker invoker) {
        this._invoker = invoker;
    }

    public ProcessRuntime getProcessRuntime() {
        return this._processRuntime;
    }

    public void setProcessRuntime(ProcessRuntime processRuntime) {
        this._processRuntime = processRuntime;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        Object fault;
        Map parameters = workItem.getParameters();
        Object content = null;
        String parameterName = this.getParameterName(parameters);
        if (parameterName != null) {
            content = parameters.get(parameterName);
        }
        QName serviceName = this.getServiceName(parameters);
        String operationName = this.getOperationName(parameters);
        SwitchYardServiceRequest request = new SwitchYardServiceRequest(serviceName, operationName, content, parameters);
        SwitchYardServiceResponse response = this.getInvoker().invoke(request);
        HashMap<String, Object> results = workItem.getResults();
        if (results == null) {
            results = new HashMap<String, Object>();
        }
        results.putAll(response.getContext());
        String resultName = this.getResultName(parameters);
        if (resultName != null) {
            results.put(resultName, response.getContent());
        }
        if ((fault = response.getFault()) == null) {
            manager.completeWorkItem(workItem.getId(), results);
        } else {
            FaultWorkItemAction faultWorkItemAction;
            String faultEventId;
            if (fault instanceof Throwable) {
                Throwable t = (Throwable)fault;
                LOGGER.error((Object)("Fault encountered: " + t.getMessage()), t);
            } else {
                LOGGER.error((Object)("Fault encountered: " + fault));
            }
            String faultResultName = this.getFaultResultName(parameters);
            if (faultResultName != null) {
                results.put(faultResultName, fault);
            }
            if ((faultEventId = this.getFaultEventId(parameters)) != null) {
                this.getProcessRuntime().signalEvent(faultEventId, fault, workItem.getProcessInstanceId());
            }
            if ((faultWorkItemAction = this.getFaultWorkItemAction(parameters)) != null) {
                switch (faultWorkItemAction) {
                    case ABORT: {
                        manager.abortWorkItem(workItem.getId());
                        break;
                    }
                    case COMPLETE: {
                        manager.completeWorkItem(workItem.getId(), results);
                    }
                }
            }
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    protected QName getServiceName(Map<String, Object> parameters) {
        return this.getQName(SERVICE_NAME, parameters, null);
    }

    protected String getOperationName(Map<String, Object> parameters) {
        return this.getString(OPERATION_NAME, parameters, null);
    }

    protected String getParameterName(Map<String, Object> parameters) {
        return this.getString(PARAMETER_NAME, parameters, "Parameter");
    }

    protected String getResultName(Map<String, Object> parameters) {
        return this.getString(RESULT_NAME, parameters, "Result");
    }

    private String getFaultResultName(Map<String, Object> parameters) {
        return this.getString(FAULT_RESULT_NAME, parameters, null);
    }

    private String getFaultEventId(Map<String, Object> parameters) {
        return this.getString(FAULT_EVENT_ID, parameters, null);
    }

    private FaultWorkItemAction getFaultWorkItemAction(Map<String, Object> parameters) {
        String s = this.getString(FAULT_WORK_ITEM_ACTION, parameters, null);
        if (s != null) {
            try {
                return FaultWorkItemAction.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                LOGGER.warn((Object)String.format("Unknown %s: %s", FaultWorkItemAction.class.getSimpleName(), iae.getMessage()));
            }
        }
        return null;
    }

    protected QName getQName(String parameterName, Map<String, Object> parameters, QName defaultValue) {
        Object serviceName = parameters.get(parameterName);
        if (serviceName instanceof QName) {
            return (QName)serviceName;
        }
        if (serviceName instanceof String) {
            return XMLHelper.createQName((String)((String)serviceName));
        }
        return defaultValue;
    }

    protected String getString(String parameterName, Map<String, Object> parameters, String defaultValue) {
        String value = null;
        Object p = parameters.get(parameterName);
        if (p != null) {
            value = Strings.trimToNull((String)String.valueOf(p));
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private static enum FaultWorkItemAction {
        ABORT,
        COMPLETE;

    }
}

