/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.util;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jbpm.process.workitem.wsht.AbstractHTWorkItemHandler;
import org.jbpm.process.workitem.wsht.LocalHTWorkItemHandler;
import org.kie.runtime.KieRuntime;
import org.kie.runtime.KnowledgeRuntime;
import org.kie.runtime.process.ProcessRuntime;
import org.kie.runtime.process.WorkItemHandler;
import org.switchyard.ServiceDomain;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.component.bpm.config.model.BPMComponentImplementationModel;
import org.switchyard.component.bpm.config.model.WorkItemHandlerModel;
import org.switchyard.component.bpm.config.model.WorkItemHandlersModel;
import org.switchyard.component.bpm.service.SwitchYardServiceTaskHandler;
import org.switchyard.component.bpm.service.SwitchYardServiceWorkItemHandler;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceInvoker;
import org.switchyard.exception.SwitchYardException;

public final class WorkItemHandlers {
    private static final String HUMAN_TASK = "Human Task";
    private static final Class<?>[][] PARAMETER_TYPES = new Class[][]{{ProcessRuntime.class}, {KieRuntime.class}, {KnowledgeRuntime.class}, new Class[0]};
    private static final Map<String, Class<? extends WorkItemHandler>> DEFAULT_HANDLERS = new HashMap<String, Class<? extends WorkItemHandler>>();

    public static void registerWorkItemHandlers(BPMComponentImplementationModel model, ClassLoader loader, ProcessRuntime runtime, ServiceDomain domain) {
        String tns = model.getComponent().getTargetNamespace();
        HashSet<String> registeredNames = new HashSet<String>();
        WorkItemHandlersModel workItemHandlersModel = model.getWorkItemHandlers();
        if (workItemHandlersModel != null) {
            for (WorkItemHandlerModel workItemHandlerModel : workItemHandlersModel.getWorkItemHandlers()) {
                Class<?> workItemHandlerClass = workItemHandlerModel.getClazz(loader);
                if (workItemHandlerClass == null) {
                    throw new SwitchYardException("Could not load workItemHandler class: " + workItemHandlerModel.getModelConfiguration().getAttribute("class"));
                }
                WorkItemHandler workItemHandler = WorkItemHandlers.newWorkItemHandler(workItemHandlerClass, runtime);
                String name = workItemHandlerModel.getName();
                if (workItemHandler instanceof SwitchYardServiceWorkItemHandler) {
                    SwitchYardServiceWorkItemHandler syswih = (SwitchYardServiceWorkItemHandler)workItemHandler;
                    if (name != null) {
                        syswih.setName(name);
                    } else {
                        name = syswih.getName();
                    }
                    syswih.setInvoker(new SwitchYardServiceInvoker(domain, tns));
                    syswih.setProcessRuntime(runtime);
                }
                if (name == null && workItemHandler instanceof AbstractHTWorkItemHandler) {
                    name = HUMAN_TASK;
                }
                if (name == null) {
                    throw new SwitchYardException("Could not use null name to register workItemHandler: " + workItemHandler.getClass().getName());
                }
                runtime.getWorkItemManager().registerWorkItemHandler(name, workItemHandler);
                registeredNames.add(name);
            }
        }
        for (Map.Entry entry : DEFAULT_HANDLERS.entrySet()) {
            String name = (String)entry.getKey();
            if (registeredNames.contains(name)) continue;
            WorkItemHandler defaultHandler = WorkItemHandlers.newWorkItemHandler((Class)entry.getValue(), runtime);
            if (defaultHandler instanceof SwitchYardServiceWorkItemHandler) {
                SwitchYardServiceWorkItemHandler syswih = (SwitchYardServiceWorkItemHandler)defaultHandler;
                syswih.setName(name);
                syswih.setInvoker(new SwitchYardServiceInvoker(domain, tns));
                syswih.setProcessRuntime(runtime);
            }
            runtime.getWorkItemManager().registerWorkItemHandler(name, defaultHandler);
            registeredNames.add(name);
        }
    }

    public static WorkItemHandler newWorkItemHandler(Class<? extends WorkItemHandler> workItemHandlerClass, ProcessRuntime runtime) {
        WorkItemHandler workItemHandler = null;
        Constructor<? extends WorkItemHandler> constructor = WorkItemHandlers.getConstructor(workItemHandlerClass);
        Class[] parameterTypes = constructor != null ? constructor.getParameterTypes() : new Class[]{};
        try {
            if (parameterTypes.length == 0) {
                workItemHandler = (WorkItemHandler)Construction.construct(workItemHandlerClass);
            } else if (parameterTypes.length == 1) {
                workItemHandler = (WorkItemHandler)Construction.construct(workItemHandlerClass, (Class[])parameterTypes, (Object[])new Object[]{runtime});
            }
        }
        catch (Throwable t) {
            throw new SwitchYardException("Could not instantiate workItemHandler class: " + workItemHandlerClass.getName());
        }
        return workItemHandler;
    }

    private static Constructor<? extends WorkItemHandler> getConstructor(Class<? extends WorkItemHandler> workItemHandlerClass) {
        Constructor<? extends WorkItemHandler> constructor = null;
        for (Class<?>[] parameterTypes : PARAMETER_TYPES) {
            try {
                constructor = workItemHandlerClass.getConstructor(parameterTypes);
                if (constructor == null) continue;
                break;
            }
            catch (Throwable t) {
                t.getMessage();
            }
        }
        return constructor;
    }

    private WorkItemHandlers() {
    }

    static {
        DEFAULT_HANDLERS.put(HUMAN_TASK, LocalHTWorkItemHandler.class);
        DEFAULT_HANDLERS.put("Service Task", SwitchYardServiceTaskHandler.class);
        DEFAULT_HANDLERS.put("SwitchYard Service", SwitchYardServiceWorkItemHandler.class);
    }
}

