/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.exchange;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.drools.persistence.jta.JtaTransactionManager;
import org.jbpm.persistence.JpaProcessPersistenceContextManager;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.kie.runtime.process.ProcessInstance;
import org.kie.runtime.process.ProcessRuntime;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.component.bpm.BPMActionType;
import org.switchyard.component.bpm.BPMConstants;
import org.switchyard.component.bpm.config.model.BPMComponentImplementationModel;
import org.switchyard.component.bpm.transaction.AS7TransactionHelper;
import org.switchyard.component.bpm.util.WorkItemHandlers;
import org.switchyard.component.common.knowledge.ActionType;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.exchange.KnowledgeAction;
import org.switchyard.component.common.knowledge.exchange.KnowledgeExchangeHandler;
import org.switchyard.component.common.knowledge.session.KnowledgeSession;
import org.switchyard.component.common.knowledge.util.Disposals;
import org.switchyard.component.common.knowledge.util.Environments;
import org.switchyard.component.common.knowledge.util.Mappings;

public class BPMExchangeHandler
extends KnowledgeExchangeHandler<BPMComponentImplementationModel> {
    private static final KnowledgeAction DEFAULT_ACTION = new KnowledgeAction(null, (ActionType)BPMActionType.START_PROCESS);
    private final boolean _persistent;
    private final String _processId;
    private EntityManagerFactory _entityManagerFactory;

    public BPMExchangeHandler(BPMComponentImplementationModel model, ServiceDomain domain) {
        super((KnowledgeComponentImplementationModel)model, domain);
        this._persistent = model.isPersistent();
        this._processId = model.getProcessId();
    }

    public void start() {
        if (this._persistent) {
            this._entityManagerFactory = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        }
        super.start();
    }

    public void stop() {
        if (this._entityManagerFactory != null) {
            Disposals.newDisposal((EntityManagerFactory)this._entityManagerFactory).dispose();
            this._entityManagerFactory = null;
        }
        super.stop();
    }

    protected Properties getPropertyOverrides() {
        return super.getPropertyOverrides();
    }

    protected Map<String, Object> getEnvironmentOverrides() {
        if (this._persistent) {
            UserTransaction ut = AS7TransactionHelper.getUserTransaction();
            TransactionManager tm = AS7TransactionHelper.getTransactionManager();
            HashMap<String, Object> env = new HashMap<String, Object>();
            env.put("org.kie.persistence.jpa.EntityManagerFactory", this._entityManagerFactory);
            env.put("org.kie.transaction.Transaction", ut);
            env.put("org.kie.transaction.TransactionManager", new JtaTransactionManager((Object)ut, null, (Object)tm));
            env.put("org.kie.persistence.PersistenceContextManager", new JpaProcessPersistenceContextManager(Environments.getEnvironment(env)));
            return env;
        }
        return super.getEnvironmentOverrides();
    }

    public KnowledgeAction getDefaultAction() {
        return DEFAULT_ACTION;
    }

    public void handleAction(Exchange exchange, KnowledgeAction action) throws HandlerException {
        Message outputMessage = null;
        AS7TransactionHelper utx = new AS7TransactionHelper(this._persistent);
        ExchangePattern exchangePattern = exchange.getContract().getProviderOperation().getExchangePattern();
        BPMActionType actionType = (BPMActionType)action.getType();
        switch (actionType) {
            case START_PROCESS: {
                try {
                    utx.begin();
                    KnowledgeSession session = this.getBPMSession(exchange);
                    ProcessInstance processInstance = session.getStateful().startProcess(this._processId, Mappings.getInputMap((Exchange)exchange, (KnowledgeAction)action));
                    if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                        outputMessage = this.handleOutput(exchange, action, session, processInstance);
                    }
                    utx.commit();
                    break;
                }
                catch (RuntimeException re) {
                    utx.rollback();
                    throw re;
                }
            }
            case SIGNAL_EVENT: {
                try {
                    utx.begin();
                    KnowledgeSession session = this.getBPMSession(exchange);
                    Long processInstanceId = this.getProcessInstanceId(exchange);
                    Object signalEvent = this.getSignalEvent(exchange);
                    String signalId = this.getSignalId(exchange, action);
                    if (processInstanceId != null) {
                        session.getStateful().signalEvent(signalId, signalEvent, processInstanceId.longValue());
                    } else {
                        session.getStateful().signalEvent(signalId, signalEvent);
                    }
                    if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                        ProcessInstance processInstance = session.getStateful().getProcessInstance(processInstanceId.longValue());
                        outputMessage = this.handleOutput(exchange, action, session, processInstance);
                    }
                    utx.commit();
                    break;
                }
                catch (RuntimeException re) {
                    utx.rollback();
                    throw re;
                }
            }
            case ABORT_PROCESS_INSTANCE: {
                try {
                    utx.begin();
                    KnowledgeSession session = this.getBPMSession(exchange);
                    Long processInstanceId = this.getProcessInstanceId(exchange);
                    session.getStateful().abortProcessInstance(processInstanceId.longValue());
                    if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                        outputMessage = this.handleOutput(exchange, action, session, null);
                    }
                    utx.commit();
                    break;
                }
                catch (RuntimeException re) {
                    utx.rollback();
                    throw re;
                }
            }
            default: {
                throw new HandlerException("Unsupported action type: " + (Object)((Object)actionType));
            }
        }
        if (outputMessage != null) {
            exchange.send(outputMessage);
        }
    }

    private KnowledgeSession getBPMSession(Exchange exchange) {
        KnowledgeSession session;
        if (this._persistent) {
            Integer sessionId = this.getInteger(exchange, BPMConstants.SESSION_ID_PROPERTY, Scope.IN);
            session = this.getPersistentSession(sessionId);
        } else {
            session = this.getStatefulSession();
        }
        WorkItemHandlers.registerWorkItemHandlers((BPMComponentImplementationModel)this.getModel(), this.getLoader(), (ProcessRuntime)session.getStateful(), this.getDomain());
        return session;
    }

    private Long getProcessInstanceId(Exchange exchange) {
        return this.getLong(exchange, BPMConstants.PROCESSS_INSTANCE_ID_PROPERTY, Scope.IN);
    }

    private Object getSignalEvent(Exchange exchange) {
        Object signalEvent = this.getObject(exchange, BPMConstants.SIGNAL_EVENT_PROPERTY, Scope.IN);
        if (signalEvent == null) {
            signalEvent = exchange.getMessage().getContent();
        }
        return signalEvent;
    }

    private String getSignalId(Exchange exchange, KnowledgeAction action) {
        String signalId = this.getString(exchange, BPMConstants.SIGNAL_ID_PROPERTY, Scope.IN);
        if (signalId == null) {
            signalId = action.getId();
        }
        return signalId;
    }

    private Message handleOutput(Exchange exchange, KnowledgeAction action, KnowledgeSession session, ProcessInstance processInstance) {
        Message outputMessage = exchange.createMessage();
        Context context = exchange.getContext();
        Integer sessionId = session.getId();
        if (sessionId != null && sessionId > 0) {
            context.setProperty(BPMConstants.SESSION_ID_PROPERTY, (Object)sessionId, Scope.OUT);
        }
        HashMap expressionVariables = new HashMap();
        if (processInstance != null) {
            Map processInstanceVariables;
            long processInstanceId = processInstance.getId();
            if (processInstanceId > 0L) {
                context.setProperty(BPMConstants.PROCESSS_INSTANCE_ID_PROPERTY, (Object)processInstanceId, Scope.OUT);
            }
            if (processInstance instanceof WorkflowProcessInstanceImpl && (processInstanceVariables = ((WorkflowProcessInstanceImpl)processInstance).getVariables()) != null) {
                expressionVariables.putAll(processInstanceVariables);
            }
        }
        Map output = Mappings.getOutputMap((Exchange)exchange, (KnowledgeAction)action, expressionVariables);
        for (Map.Entry entry : output.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            String key = (String)entry.getKey();
            if ("contentOutput".equals(key)) {
                outputMessage.setContent(value);
                continue;
            }
            context.setProperty(key, value, Scope.OUT);
        }
        return outputMessage;
    }
}

