/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.task.work.jbpm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.drools.SystemEventListenerFactory;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.drools.task.service.ResponseHandler;
import org.jbpm.eventmessaging.EventKey;
import org.jbpm.eventmessaging.EventResponseHandler;
import org.jbpm.eventmessaging.Payload;
import org.jbpm.task.Content;
import org.jbpm.task.Status;
import org.jbpm.task.event.TaskCompletedEvent;
import org.jbpm.task.event.TaskEvent;
import org.jbpm.task.event.TaskEventKey;
import org.jbpm.task.event.TaskFailedEvent;
import org.jbpm.task.event.TaskSkippedEvent;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.mina.BaseMinaHandler;
import org.jbpm.task.service.mina.MinaTaskClientConnector;
import org.jbpm.task.service.mina.MinaTaskClientHandler;
import org.jbpm.task.service.responsehandlers.AbstractBaseResponseHandler;
import org.switchyard.common.type.Classes;
import org.switchyard.common.type.reflect.FieldAccess;
import org.switchyard.component.bpm.task.work.Task;
import org.switchyard.component.bpm.task.work.TaskManager;
import org.switchyard.component.bpm.task.work.drools.DroolsTaskHandler;
import org.switchyard.component.bpm.task.work.drools.DroolsTaskManager;

public class WSHumanTaskHandler
extends DroolsTaskHandler {
    private static final Class<?>[] RESPONSE_HANDLER_INTERFACES = new Class[]{ResponseHandler.class, EventResponseHandler.class, TaskClientHandler.AddAttachmentResponseHandler.class, TaskClientHandler.AddCommentResponseHandler.class, TaskClientHandler.AddTaskResponseHandler.class, TaskClientHandler.DeleteAttachmentResponseHandler.class, TaskClientHandler.DeleteCommentResponseHandler.class, TaskClientHandler.GetContentResponseHandler.class, TaskClientHandler.GetTaskResponseHandler.class, TaskClientHandler.QueryGenericResponseHandler.class, TaskClientHandler.SetDocumentResponseHandler.class, TaskClientHandler.TaskOperationResponseHandler.class, TaskClientHandler.TaskSummaryResponseHandler.class};
    public static final String HUMAN_TASK = "Human Task";
    private Connector _connector = null;

    public WSHumanTaskHandler() {
        super(HUMAN_TASK);
    }

    public WSHumanTaskHandler(String name) {
        super(name);
    }

    @Override
    public void destroy() {
        if (this._connector != null) {
            this._connector.dispose();
        }
    }

    @Override
    public final void executeTask(Task task, TaskManager manager) {
        this.init(manager);
        super.executeTask(task, manager);
    }

    @Override
    public final void abortTask(Task task, TaskManager manager) {
        this.init(manager);
        super.abortTask(task, manager);
    }

    protected synchronized void init(TaskManager manager) {
        if (this._connector == null) {
            KnowledgeRuntime kruntime = (KnowledgeRuntime)((DroolsTaskManager)manager).getProcessRuntime();
            this._connector = this.newConnector(kruntime);
            this._connector.connect();
            this.setWorkItemHandler(this._connector.getWorkItemHandler());
        }
    }

    protected Connector newConnector(KnowledgeRuntime kruntime) {
        final TCCLWSHumanTaskHandler handler = new TCCLWSHumanTaskHandler(kruntime, this.getLoader());
        return new Connector((WorkItemHandler)handler){

            @Override
            public void doConnect() throws Exception {
                handler.connect();
            }

            @Override
            public void doDispose() throws Exception {
                handler.dispose();
            }
        };
    }

    protected static <T extends ResponseHandler> T proxyHandler(T handler, ClassLoader loader) {
        return (T)((ResponseHandler)Proxy.newProxyInstance(loader, RESPONSE_HANDLER_INTERFACES, (InvocationHandler)new TCCLInvocationHandler(handler, loader)));
    }

    protected static abstract class Connector {
        private final WorkItemHandler _handler;

        protected Connector(WorkItemHandler handler) {
            this._handler = handler;
        }

        protected final WorkItemHandler getWorkItemHandler() {
            return this._handler;
        }

        protected final void connect() {
            boolean ready = false;
            int attempts = 0;
            Exception exception = null;
            while (!ready) {
                try {
                    this.doConnect();
                    ready = true;
                }
                catch (Throwable t) {
                    block6: {
                        try {
                            this.dispose();
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {
                            if (exception != null) break block6;
                            exception = e;
                        }
                    }
                    ready = ++attempts > 9;
                }
            }
            if (exception != null) {
                throw new RuntimeException(exception);
            }
        }

        protected abstract void doConnect() throws Exception;

        protected final void dispose() {
            try {
                this.doDispose();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract void doDispose() throws Exception;
    }

    private static final class TCCLInvocationHandler
    implements InvocationHandler {
        private final Object _wrapped;
        private final ClassLoader _loader;

        private TCCLInvocationHandler(Object wrapped, ClassLoader loader) {
            this._wrapped = wrapped;
            this._loader = loader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ClassLoader previousLoader = Classes.setTCCL((ClassLoader)this._loader);
            try {
                Object object = method.invoke(this._wrapped, args);
                return object;
            }
            finally {
                Classes.setTCCL((ClassLoader)previousLoader);
            }
        }
    }

    private static class GetResultContentResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.GetContentResponseHandler {
        private WorkItemManager _manager;
        private org.jbpm.task.Task _task;
        private Map<String, Object> _results;

        public GetResultContentResponseHandler(WorkItemManager manager, org.jbpm.task.Task task, Map<String, Object> results) {
            this._manager = manager;
            this._task = task;
            this._results = results;
        }

        public void execute(Content content) {
            ByteArrayInputStream bis = new ByteArrayInputStream(content.getContent());
            try {
                ObjectInputStream in = new ObjectInputStream(bis){

                    @Override
                    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                        Class<?> clazz = Classes.forName((String)desc.getName(), this.getClass());
                        return clazz != null ? clazz : super.resolveClass(desc);
                    }
                };
                Object result = in.readObject();
                in.close();
                this._results.put("Result", result);
                if (result instanceof Map) {
                    Map map = (Map)result;
                    for (Map.Entry entry : map.entrySet()) {
                        if (!(entry.getKey() instanceof String)) continue;
                        this._results.put((String)entry.getKey(), entry.getValue());
                    }
                }
                this._manager.completeWorkItem(this._task.getTaskData().getWorkItemId(), this._results);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private static class GetCompletedTaskResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.GetTaskResponseHandler {
        private WorkItemManager _manager;
        private TaskClient _client;

        public GetCompletedTaskResponseHandler(WorkItemManager manager, TaskClient client) {
            this._manager = manager;
            this._client = client;
        }

        public void execute(org.jbpm.task.Task task) {
            long workItemId = task.getTaskData().getWorkItemId();
            if (task.getTaskData().getStatus() == Status.Completed) {
                String userId = task.getTaskData().getActualOwner().getId();
                HashMap<String, Object> results = new HashMap<String, Object>();
                results.put("ActorId", userId);
                long contentId = task.getTaskData().getOutputContentId();
                if (contentId != -1L) {
                    GetResultContentResponseHandler getContentResponseHandler = new GetResultContentResponseHandler(this._manager, task, results);
                    this._client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getContentResponseHandler);
                } else {
                    this._manager.completeWorkItem(workItemId, results);
                }
            } else {
                this._manager.abortWorkItem(workItemId);
            }
        }
    }

    private static class TaskCompletedHandler
    extends AbstractBaseResponseHandler
    implements EventResponseHandler {
        private WorkItemManager _manager;
        private TaskClient _client;

        public TaskCompletedHandler(WorkItemManager manager, TaskClient client) {
            this._manager = manager;
            this._client = client;
        }

        public void execute(Payload payload) {
            TaskEvent event = (TaskEvent)payload.get();
            long taskId = event.getTaskId();
            GetCompletedTaskResponseHandler getTaskResponseHandler = new GetCompletedTaskResponseHandler(this._manager, this._client);
            this._client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        }

        public boolean isRemove() {
            return false;
        }
    }

    private static final class TCCLWSHumanTaskHandler
    extends org.jbpm.process.workitem.wsht.WSHumanTaskHandler {
        private final ClassLoader _loader;
        private TaskClient _client = null;
        private WorkItemManager _manager = null;
        private boolean _initialized = false;

        private TCCLWSHumanTaskHandler(KnowledgeRuntime session, ClassLoader loader) {
            super(session);
            this._loader = loader;
        }

        public void connect() {
            if (!this._initialized) {
                FieldAccess clientAccess = new FieldAccess(org.jbpm.process.workitem.wsht.WSHumanTaskHandler.class, "client");
                this._client = (TaskClient)clientAccess.read((Object)this);
                if (this._client == null) {
                    this._client = new TaskClient((TaskClientConnector)new MinaTaskClientConnector("org.drools.process.workitem.wsht.WSHumanTaskHandler", (BaseMinaHandler)new MinaTaskClientHandler(SystemEventListenerFactory.getSystemEventListener())));
                    boolean connected = this._client.connect("127.0.0.1", 9123);
                    if (!connected) {
                        throw new IllegalArgumentException("Could not connect task client");
                    }
                }
                TaskEventKey key = new TaskEventKey(TaskCompletedEvent.class, -1L);
                this._manager = (WorkItemManager)new FieldAccess(WorkItemManager.class, "manager").read((Object)this);
                EventResponseHandler eventResponseHandler = WSHumanTaskHandler.proxyHandler(new TaskCompletedHandler(this._manager, this._client), this._loader);
                this._client.registerForEvent((EventKey)key, false, eventResponseHandler);
                key = new TaskEventKey(TaskFailedEvent.class, -1L);
                this._client.registerForEvent((EventKey)key, false, eventResponseHandler);
                key = new TaskEventKey(TaskSkippedEvent.class, -1L);
                this._client.registerForEvent((EventKey)key, false, eventResponseHandler);
                clientAccess.write((Object)this, (Object)this._client);
                this._initialized = true;
                new FieldAccess(org.jbpm.process.workitem.wsht.WSHumanTaskHandler.class, "initialized").write((Object)this, (Object)this._initialized);
            }
        }
    }
}

