/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.task.work.jbpm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import java.util.Map;
import org.drools.SystemEventListenerFactory;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.process.WorkItemHandler;
import org.jbpm.eventmessaging.EventKey;
import org.jbpm.eventmessaging.EventResponseHandler;
import org.jbpm.eventmessaging.Payload;
import org.jbpm.task.Content;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.event.TaskCompletedEvent;
import org.jbpm.task.event.TaskEvent;
import org.jbpm.task.event.TaskEventKey;
import org.jbpm.task.event.TaskFailedEvent;
import org.jbpm.task.event.TaskSkippedEvent;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.mina.BaseMinaHandler;
import org.jbpm.task.service.mina.MinaTaskClientConnector;
import org.jbpm.task.service.mina.MinaTaskClientHandler;
import org.jbpm.task.service.responsehandlers.AbstractBaseResponseHandler;
import org.switchyard.common.type.Classes;
import org.switchyard.common.type.reflect.FieldAccess;
import org.switchyard.component.bpm.task.work.jbpm.WSHumanTaskHandler;

public class CommandBasedWSHumanTaskHandler
extends WSHumanTaskHandler {
    public CommandBasedWSHumanTaskHandler() {
    }

    public CommandBasedWSHumanTaskHandler(String name) {
        super(name);
    }

    @Override
    protected WSHumanTaskHandler.Connector newConnector(KnowledgeRuntime kruntime) {
        final TCCLCommandBasedWSHumanTaskHandler handler = new TCCLCommandBasedWSHumanTaskHandler(kruntime, this.getLoader());
        return new WSHumanTaskHandler.Connector((WorkItemHandler)handler){

            @Override
            public void doConnect() throws Exception {
                handler.connect();
            }

            @Override
            public void doDispose() throws Exception {
                handler.dispose();
            }
        };
    }

    private static final class TCCLCommandBasedWSHumanTaskHandler
    extends org.jbpm.process.workitem.wsht.CommandBasedWSHumanTaskHandler {
        private final KnowledgeRuntime _session;
        private final ClassLoader _loader;
        private TaskClient _client = null;

        private TCCLCommandBasedWSHumanTaskHandler(KnowledgeRuntime session, ClassLoader loader) {
            super(session);
            this._session = session;
            this._loader = loader;
        }

        public void connect() {
            if (this._client == null) {
                this._client = new TaskClient((TaskClientConnector)new MinaTaskClientConnector("org.drools.process.workitem.wsht.WSHumanTaskHandler", (BaseMinaHandler)new MinaTaskClientHandler(SystemEventListenerFactory.getSystemEventListener())));
                boolean connected = this._client.connect("127.0.0.1", 9123);
                if (!connected) {
                    throw new IllegalArgumentException("Could not connect task client");
                }
                TaskEventKey key = new TaskEventKey(TaskCompletedEvent.class, -1L);
                EventResponseHandler eventResponseHandler = WSHumanTaskHandler.proxyHandler(new TaskCompletedHandler(), this._loader);
                this._client.registerForEvent((EventKey)key, false, eventResponseHandler);
                key = new TaskEventKey(TaskFailedEvent.class, -1L);
                this._client.registerForEvent((EventKey)key, false, eventResponseHandler);
                key = new TaskEventKey(TaskSkippedEvent.class, -1L);
                this._client.registerForEvent((EventKey)key, false, eventResponseHandler);
                new FieldAccess(org.jbpm.process.workitem.wsht.CommandBasedWSHumanTaskHandler.class, "client").write((Object)this, (Object)this._client);
            }
        }

        private class GetResultContentResponseHandler
        extends AbstractBaseResponseHandler
        implements TaskClientHandler.GetContentResponseHandler {
            private final Task _task;
            private final Map<String, Object> _results;

            public GetResultContentResponseHandler(Task task, Map<String, Object> results) {
                this._task = task;
                this._results = results;
            }

            public void execute(Content content) {
                ByteArrayInputStream bis = new ByteArrayInputStream(content.getContent());
                try {
                    ObjectInputStream in = new ObjectInputStream(bis){

                        @Override
                        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                            Class<?> clazz = Classes.forName((String)desc.getName(), this.getClass());
                            return clazz != null ? clazz : super.resolveClass(desc);
                        }
                    };
                    Object result = in.readObject();
                    in.close();
                    this._results.put("Result", result);
                    if (result instanceof Map) {
                        Map map = (Map)result;
                        for (Map.Entry entry : map.entrySet()) {
                            if (!(entry.getKey() instanceof String)) continue;
                            this._results.put((String)entry.getKey(), entry.getValue());
                        }
                    }
                    TCCLCommandBasedWSHumanTaskHandler.this._session.getWorkItemManager().completeWorkItem(this._task.getTaskData().getWorkItemId(), this._results);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }

        private class GetCompletedTaskResponseHandler
        extends AbstractBaseResponseHandler
        implements TaskClientHandler.GetTaskResponseHandler {
            private GetCompletedTaskResponseHandler() {
            }

            public void execute(Task task) {
                long workItemId = task.getTaskData().getWorkItemId();
                if (task.getTaskData().getStatus() == Status.Completed) {
                    String userId = task.getTaskData().getActualOwner().getId();
                    HashMap<String, Object> results = new HashMap<String, Object>();
                    results.put("ActorId", userId);
                    long contentId = task.getTaskData().getOutputContentId();
                    if (contentId != -1L) {
                        GetResultContentResponseHandler getContentResponseHandler = new GetResultContentResponseHandler(task, results);
                        TCCLCommandBasedWSHumanTaskHandler.this._client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getContentResponseHandler);
                    } else {
                        TCCLCommandBasedWSHumanTaskHandler.this._session.getWorkItemManager().completeWorkItem(workItemId, results);
                    }
                } else {
                    TCCLCommandBasedWSHumanTaskHandler.this._session.getWorkItemManager().abortWorkItem(workItemId);
                }
            }
        }

        private class TaskCompletedHandler
        extends AbstractBaseResponseHandler
        implements EventResponseHandler {
            private TaskCompletedHandler() {
            }

            public void execute(Payload payload) {
                TaskEvent event = (TaskEvent)payload.get();
                long taskId = event.getTaskId();
                GetCompletedTaskResponseHandler getTaskResponseHandler = new GetCompletedTaskResponseHandler();
                TCCLCommandBasedWSHumanTaskHandler.this._client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
            }

            public boolean isRemove() {
                return false;
            }
        }
    }
}

