/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.task.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.Map;
import org.switchyard.common.type.Classes;
import org.switchyard.component.bpm.task.service.TaskContent;
import org.switchyard.exception.SwitchYardException;

public abstract class BaseTaskContent
implements TaskContent {
    private Long _id;

    @Override
    public Long getId() {
        return this._id;
    }

    @Override
    public TaskContent setId(Long id) {
        this._id = id;
        return this;
    }

    @Override
    public Object getObject() {
        Object object = null;
        byte[] bytes = this.getBytes();
        if (bytes != null && bytes.length > 0) {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(bais){

                    @Override
                    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                        Class<?> clazz = Classes.forName((String)desc.getName(), this.getClass());
                        return clazz != null ? clazz : super.resolveClass(desc);
                    }
                };
                object = ois.readObject();
            }
            catch (IOException ioe) {
                throw new SwitchYardException((Throwable)ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new SwitchYardException((Throwable)cnfe);
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException ioe) {
                        throw new SwitchYardException((Throwable)ioe);
                    }
                }
            }
        }
        return object;
    }

    @Override
    public <T> T getObject(Class<T> clazz) {
        return clazz.cast(this.getObject());
    }

    @Override
    public TaskContent setObject(Object object) {
        byte[] bytes = null;
        if (object != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(baos);
                oos.writeObject(object);
                oos.flush();
            }
            catch (IOException ioe) {
                throw new SwitchYardException((Throwable)ioe);
            }
            finally {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException ioe) {
                        throw new SwitchYardException((Throwable)ioe);
                    }
                }
            }
            bytes = baos.toByteArray();
        }
        this.setBytes(bytes);
        return this;
    }

    @Override
    public Map<String, Object> getMap() {
        return this.getObject(Map.class);
    }

    @Override
    public TaskContent setMap(Map<String, Object> map) {
        this.setObject(map);
        return this;
    }
}

