/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.task.work.jbpm;

import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.process.WorkItemHandler;
import org.switchyard.component.bpm.task.work.Task;
import org.switchyard.component.bpm.task.work.TaskManager;
import org.switchyard.component.bpm.task.work.drools.DroolsTaskHandler;
import org.switchyard.component.bpm.task.work.drools.DroolsTaskManager;

public class WSHumanTaskHandler
extends DroolsTaskHandler {
    public static final String HUMAN_TASK = "Human Task";
    private Connector _connector = null;

    public WSHumanTaskHandler() {
        super(HUMAN_TASK);
    }

    public WSHumanTaskHandler(String name) {
        super(name);
    }

    @Override
    public void destroy() {
        if (this._connector != null) {
            this._connector.dispose();
        }
    }

    @Override
    public final void executeTask(Task task, TaskManager manager) {
        this.init(manager);
        super.executeTask(task, manager);
    }

    @Override
    public final void abortTask(Task task, TaskManager manager) {
        this.init(manager);
        super.abortTask(task, manager);
    }

    protected synchronized void init(TaskManager manager) {
        if (this._connector == null) {
            KnowledgeRuntime kruntime = (KnowledgeRuntime)((DroolsTaskManager)manager).getProcessRuntime();
            this._connector = this.newConnector(kruntime);
            this._connector.connect();
            this.setWorkItemHandler(this._connector.getWorkItemHandler());
        }
    }

    protected Connector newConnector(KnowledgeRuntime kruntime) {
        final org.jbpm.process.workitem.wsht.WSHumanTaskHandler handler = new org.jbpm.process.workitem.wsht.WSHumanTaskHandler(kruntime);
        return new Connector((WorkItemHandler)handler){

            @Override
            public void doConnect() throws Exception {
                handler.connect();
            }

            @Override
            public void doDispose() throws Exception {
                handler.dispose();
            }
        };
    }

    protected static abstract class Connector {
        private final WorkItemHandler _handler;

        public Connector(WorkItemHandler handler) {
            this._handler = handler;
        }

        public final WorkItemHandler getWorkItemHandler() {
            return this._handler;
        }

        public final void connect() {
            boolean ready = false;
            int attempts = 0;
            Exception exception = null;
            while (!ready) {
                try {
                    this.doConnect();
                    ready = true;
                }
                catch (Throwable t) {
                    block6: {
                        try {
                            this.dispose();
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {
                            if (exception != null) break block6;
                            exception = e;
                        }
                    }
                    ready = ++attempts > 9;
                }
            }
            if (exception != null) {
                throw new RuntimeException(exception);
            }
        }

        public abstract void doConnect() throws Exception;

        public final void dispose() {
            try {
                this.doDispose();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public abstract void doDispose() throws Exception;
    }
}

