/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.task.service.jbpm;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.drools.SystemEventListenerFactory;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.mina.BaseMinaHandler;
import org.jbpm.task.service.mina.MinaTaskClientConnector;
import org.jbpm.task.service.mina.MinaTaskClientHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskOperationResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskSummaryResponseHandler;
import org.switchyard.component.bpm.task.service.BaseTaskClient;
import org.switchyard.component.bpm.task.service.Task;
import org.switchyard.component.bpm.task.service.jbpm.JBPMTask;

public class JBPMTaskClient
extends BaseTaskClient {
    private static final Logger LOGGER = Logger.getLogger(JBPMTaskClient.class);
    private TaskClient _wrapped = null;

    @Override
    public void connect() {
        if (this._wrapped == null) {
            this._wrapped = new TaskClient((TaskClientConnector)new MinaTaskClientConnector(JBPMTaskClient.class.getSimpleName(), (BaseMinaHandler)new MinaTaskClientHandler(SystemEventListenerFactory.getSystemEventListener())));
        }
        if (!this.isConnected()) {
            LOGGER.info((Object)String.format("Connecting jBPM TaskClient to %s:%s...", this.getHost(), this.getPort()));
            this.setConnected(this._wrapped.connect(this.getHost(), this.getPort()));
            if (this.isConnected()) {
                LOGGER.info((Object)String.format("jBPM TaskClient connected to %s:%s.", this.getHost(), this.getPort()));
            } else {
                LOGGER.error((Object)String.format("jBPM TaskClient could not connect to %s:%s!", this.getHost(), this.getPort()));
            }
        }
    }

    @Override
    public void disconnect() {
        if (this._wrapped != null) {
            if (this.isConnected()) {
                LOGGER.info((Object)String.format("Disconnecting jBPM TaskClient from %s:%s...", this.getHost(), this.getPort()));
                try {
                    this._wrapped.disconnect();
                }
                catch (Throwable t) {
                    t.getMessage();
                }
                this.setConnected(false);
                LOGGER.info((Object)String.format("jBPM TaskClient disconnected from %s:%s.", this.getHost(), this.getPort()));
            }
            this._wrapped = null;
        }
    }

    @Override
    public List<Task> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, Locale locale) {
        String language = locale != null ? locale.toString().replace('_', '-') : null;
        BlockingTaskSummaryResponseHandler btsrh = new BlockingTaskSummaryResponseHandler();
        this._wrapped.getTasksAssignedAsPotentialOwner(userId, groupIds, language, (TaskClientHandler.TaskSummaryResponseHandler)btsrh);
        List taskSummaries = btsrh.getResults();
        int size = taskSummaries.size();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Found %s task%s for %s.", size, size == 1 ? "" : "s", userId));
        }
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (TaskSummary taskSummary : taskSummaries) {
            tasks.add(new JBPMTask(taskSummary));
        }
        return tasks;
    }

    @Override
    public void claim(Long taskId, String userId, List<String> groupIds) {
        BlockingTaskOperationResponseHandler btorh = new BlockingTaskOperationResponseHandler();
        this._wrapped.claim(taskId.longValue(), userId, groupIds, (TaskClientHandler.TaskOperationResponseHandler)btorh);
        btorh.waitTillDone(10000L);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Task %s claimed by %s.", taskId, userId));
        }
    }

    @Override
    public void start(Long taskId, String userId) {
        BlockingTaskOperationResponseHandler btorh = new BlockingTaskOperationResponseHandler();
        this._wrapped.start(taskId.longValue(), userId, (TaskClientHandler.TaskOperationResponseHandler)btorh);
        btorh.waitTillDone(10000L);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Task %s started by %s.", taskId, userId));
        }
    }

    @Override
    public void complete(Long taskId, String userId) {
        BlockingTaskOperationResponseHandler btorh = new BlockingTaskOperationResponseHandler();
        this._wrapped.complete(taskId.longValue(), userId, null, (TaskClientHandler.TaskOperationResponseHandler)btorh);
        btorh.waitTillDone(10000L);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Task %s completed by %s.", taskId, userId));
        }
    }
}

