/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.exchange.drools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.drools.KnowledgeBase;
import org.drools.agent.KnowledgeAgent;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.ProcessRuntime;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.common.io.resource.Resource;
import org.switchyard.common.io.resource.ResourceType;
import org.switchyard.common.io.resource.SimpleResource;
import org.switchyard.common.type.Classes;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.component.bpm.ProcessActionType;
import org.switchyard.component.bpm.ProcessConstants;
import org.switchyard.component.bpm.config.model.BPMComponentImplementationModel;
import org.switchyard.component.bpm.config.model.ProcessActionModel;
import org.switchyard.component.bpm.config.model.TaskHandlerModel;
import org.switchyard.component.bpm.exchange.BaseBPMExchangeHandler;
import org.switchyard.component.bpm.task.work.TaskHandler;
import org.switchyard.component.bpm.task.work.drools.DroolsTaskManager;
import org.switchyard.component.common.rules.config.model.AuditModel;
import org.switchyard.component.common.rules.config.model.ComponentImplementationModel;
import org.switchyard.component.common.rules.util.drools.Agents;
import org.switchyard.component.common.rules.util.drools.Audits;
import org.switchyard.component.common.rules.util.drools.Bases;
import org.switchyard.component.common.rules.util.drools.ComponentImplementationConfig;
import org.switchyard.component.common.rules.util.drools.Configs;
import org.switchyard.component.common.rules.util.drools.Environments;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.metadata.ServiceOperation;

public class DroolsBPMExchangeHandler
extends BaseBPMExchangeHandler {
    private static final Logger LOGGER = Logger.getLogger(DroolsBPMExchangeHandler.class);
    private final ServiceDomain _serviceDomain;
    private String _processId;
    private String _messageContentInName;
    private String _messageContentOutName;
    private KnowledgeAgent _kagent;
    private AuditModel _audit;
    private String _targetNamespace;
    private List<TaskHandlerModel> _taskHandlerModels = new ArrayList<TaskHandlerModel>();
    private List<TaskHandler> _taskHandlers = new ArrayList<TaskHandler>();
    private Map<String, ProcessActionModel> _actionModels = new HashMap<String, ProcessActionModel>();
    private KnowledgeBase _kbase;
    private KnowledgeSessionConfiguration _ksessionConfig;
    private Environment _environment;
    private StatefulKnowledgeSession _ksession;
    private KnowledgeRuntimeLogger _klogger;

    public DroolsBPMExchangeHandler(ServiceDomain serviceDomain) {
        this._serviceDomain = serviceDomain;
    }

    @Override
    public void init(QName qname, BPMComponentImplementationModel model) {
        ComponentModel cm;
        this._processId = model.getProcessId();
        this._messageContentInName = model.getMessageContentInName();
        if (this._messageContentInName == null) {
            this._messageContentInName = "messageContentIn";
        }
        this._messageContentOutName = model.getMessageContentOutName();
        if (this._messageContentOutName == null) {
            this._messageContentOutName = "messageContentOut";
        }
        this._targetNamespace = (cm = model.getComponent()) != null ? cm.getTargetNamespace() : null;
        this._taskHandlerModels.addAll(model.getTaskHandlers());
        ClassLoader loader = Classes.getClassLoader(this.getClass());
        ResourceType.install((ClassLoader)loader);
        ComponentImplementationConfig cic = new ComponentImplementationConfig((ComponentImplementationModel)model, loader);
        HashMap env = new HashMap();
        cic.setEnvironmentOverrides(env);
        Properties props = new Properties();
        cic.setPropertiesOverrides(props);
        Resource procDef = model.getProcessDefinition();
        if (procDef.getType() == null) {
            procDef = new SimpleResource(procDef.getLocation(), "BPMN2");
        }
        if (model.isAgent()) {
            this._kagent = Agents.newAgent((ComponentImplementationConfig)cic, (Resource[])new Resource[]{procDef});
            this._kbase = this._kagent.getKnowledgeBase();
        } else {
            this._kbase = Bases.newBase((ComponentImplementationConfig)cic, (Resource[])new Resource[]{procDef});
        }
        this._ksessionConfig = Configs.getSessionConfiguration((ComponentImplementationConfig)cic);
        this._environment = Environments.getEnvironment((ComponentImplementationConfig)cic);
        this._audit = model.getAudit();
        for (ProcessActionModel pam : model.getProcessActions()) {
            this._actionModels.put(pam.getName(), pam);
        }
    }

    public void start() {
        this._ksession = this._kbase.newStatefulKnowledgeSession(this._ksessionConfig, this._environment);
        this._klogger = Audits.getLogger((AuditModel)this._audit, (KnowledgeRuntimeEventManager)this._ksession);
        DroolsTaskManager tm = new DroolsTaskManager((ProcessRuntime)this._ksession);
        for (TaskHandlerModel thm : this._taskHandlerModels) {
            TaskHandler th = (TaskHandler)Construction.construct(thm.getClazz());
            String name = thm.getName();
            if (name != null) {
                th.setName(name);
            }
            th.setMessageContentInName(this._messageContentInName);
            th.setMessageContentOutName(this._messageContentOutName);
            th.setTargetNamespace(this._targetNamespace);
            th.setServiceDomain(this._serviceDomain);
            tm.registerHandler(th);
            th.init();
            this._taskHandlers.add(th);
        }
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        if (!ExchangePhase.IN.equals((Object)exchange.getPhase())) {
            return;
        }
        Context context = exchange.getContext();
        ServiceOperation serviceOperation = exchange.getContract().getServiceOperation();
        ProcessActionModel processActionModel = this._actionModels.get(serviceOperation.getName());
        ProcessActionType processActionType = this.getProcessActionType(context, processActionModel);
        Message messageIn = exchange.getMessage();
        Long processInstanceId = null;
        ProcessInstance processInstance = null;
        switch (processActionType) {
            case START_PROCESS: {
                if (this._processId != null) {
                    Object messageContentIn = messageIn.getContent();
                    if (messageContentIn != null) {
                        HashMap<String, Object> parameters = new HashMap<String, Object>();
                        parameters.put(this._messageContentInName, messageContentIn);
                        processInstance = this._ksession.startProcess(this._processId, parameters);
                    } else {
                        processInstance = this._ksession.startProcess(this._processId);
                    }
                    processInstanceId = processInstance.getId();
                    break;
                }
                this.throwNullParameterException(processActionType, ProcessConstants.PROCESS_ID_VAR);
                break;
            }
            case SIGNAL_EVENT: {
                String processEventType = this.getProcessEventType(context, processActionModel);
                Object processEvent = this.getProcessEvent(context, messageIn);
                processInstanceId = this.getProcessInstanceId(context);
                if (processInstanceId != null) {
                    this._ksession.signalEvent(processEventType, processEvent, processInstanceId.longValue());
                    break;
                }
                this.throwNullParameterException(processActionType, ProcessConstants.PROCESS_INSTANCE_ID_VAR);
                break;
            }
            case ABORT_PROCESS_INSTANCE: {
                processInstanceId = this.getProcessInstanceId(context);
                if (processInstanceId != null) {
                    this._ksession.abortProcessInstance(processInstanceId.longValue());
                    break;
                }
                this.throwNullParameterException(processActionType, ProcessConstants.PROCESS_INSTANCE_ID_VAR);
            }
        }
        if (processInstanceId != null) {
            context.setProperty(ProcessConstants.PROCESS_INSTANCE_ID_VAR, (Object)processInstanceId, Scope.EXCHANGE);
            ExchangePattern exchangePattern = serviceOperation.getExchangePattern();
            if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                if (processInstance == null) {
                    processInstance = this._ksession.getProcessInstance(processInstanceId.longValue());
                }
                Message messageOut = exchange.createMessage();
                Object messageContentOut = null;
                if (processInstance != null) {
                    messageContentOut = ((WorkflowProcessInstance)processInstance).getVariable(this._messageContentOutName);
                }
                if (messageContentOut != null) {
                    messageOut.setContent(messageContentOut);
                }
                exchange.send(messageOut);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        for (TaskHandler th : this._taskHandlers) {
            try {
                th.destroy();
            }
            catch (Throwable t) {
                LOGGER.error((Object)("problem destroying TaskHandler: " + th.getName()), t);
            }
        }
        if (this._ksession != null) {
            try {
                this._ksession.halt();
            }
            finally {
                try {
                    this._ksession.dispose();
                }
                finally {
                    this._ksession = null;
                    if (this._klogger != null) {
                        try {
                            this._klogger.close();
                        }
                        finally {
                            this._klogger = null;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this._kbase = null;
        this._taskHandlers.clear();
        this._taskHandlerModels.clear();
        this._actionModels.clear();
        this._messageContentInName = null;
        this._messageContentOutName = null;
        this._processId = null;
        if (this._kagent != null) {
            try {
                this._kagent.dispose();
            }
            finally {
                this._kagent = null;
            }
        }
    }
}

