/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.config.model;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import org.switchyard.common.io.resource.Resource;
import org.switchyard.common.io.resource.ResourceType;
import org.switchyard.common.io.resource.SimpleResource;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.classpath.ClasspathScanner;
import org.switchyard.common.type.classpath.Filter;
import org.switchyard.common.type.classpath.IsAnnotationPresentFilter;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.component.bpm.AbortProcessInstance;
import org.switchyard.component.bpm.Process;
import org.switchyard.component.bpm.ProcessActionType;
import org.switchyard.component.bpm.SignalEvent;
import org.switchyard.component.bpm.StartProcess;
import org.switchyard.component.bpm.config.model.ProcessActionModel;
import org.switchyard.component.bpm.config.model.v1.V1BPMComponentImplementationModel;
import org.switchyard.component.bpm.config.model.v1.V1ProcessActionModel;
import org.switchyard.component.bpm.config.model.v1.V1TaskHandlerModel;
import org.switchyard.component.bpm.task.work.SwitchYardServiceTaskHandler;
import org.switchyard.component.bpm.task.work.TaskHandler;
import org.switchyard.component.common.rules.Audit;
import org.switchyard.component.common.rules.config.model.AuditModel;
import org.switchyard.component.common.rules.config.model.v1.V1AuditModel;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.Scanner;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.ScannerOutput;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.config.model.composite.v1.V1ComponentModel;
import org.switchyard.config.model.composite.v1.V1ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1CompositeModel;
import org.switchyard.config.model.composite.v1.V1InterfaceModel;
import org.switchyard.config.model.resource.v1.V1ResourceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.switchyard.v1.V1SwitchYardModel;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.metadata.java.JavaService;

public class BPMSwitchYardScanner
implements Scanner<SwitchYardModel> {
    private static final IsAnnotationPresentFilter START_PROCESS_FILTER = new IsAnnotationPresentFilter(StartProcess.class);
    private static final IsAnnotationPresentFilter SIGNAL_EVENT_FILTER = new IsAnnotationPresentFilter(SignalEvent.class);
    private static final IsAnnotationPresentFilter ABORT_PROCESS_INSTANCE_FILTER = new IsAnnotationPresentFilter(AbortProcessInstance.class);
    private static final String UNDEFINED = "";
    private static final String INTERFACE_ERR_MSG = " is a class. @Process only allowed on interfaces.";
    private static final String FILTER_ERR_MSG = " is in error. @StartProcess, @SignalEvent and @AbortProcessInstance cannot co-exist on the same method.";
    private final IsAnnotationPresentFilter _processFilter = new IsAnnotationPresentFilter(Process.class);

    public ScannerOutput<SwitchYardModel> scan(ScannerInput<SwitchYardModel> input) throws IOException {
        V1SwitchYardModel switchyardModel = new V1SwitchYardModel();
        V1CompositeModel compositeModel = new V1CompositeModel();
        compositeModel.setName(input.getName());
        ClasspathScanner processScanner = new ClasspathScanner((Filter)this._processFilter);
        for (URL url : input.getURLs()) {
            processScanner.scan(url);
        }
        List processClasses = this._processFilter.getMatchedTypes();
        for (Class processClass : processClasses) {
            String messageContentOutName;
            String messageContentInName;
            Process process = processClass.getAnnotation(Process.class);
            Class processInterface = process.value();
            if (Process.UndefinedProcessInterface.class.equals(processInterface)) {
                processInterface = processClass;
            }
            if (!processInterface.isInterface()) {
                throw new IOException(processInterface.getName() + INTERFACE_ERR_MSG);
            }
            String processName = Strings.trimToNull((String)process.name());
            if (processName == null) {
                processName = processInterface.getSimpleName();
            }
            V1InterfaceModel csiModel = new V1InterfaceModel("java");
            csiModel.setInterface(processInterface.getName());
            V1ComponentServiceModel serviceModel = new V1ComponentServiceModel();
            serviceModel.setInterface((InterfaceModel)csiModel);
            serviceModel.setName(processName);
            V1ComponentModel componentModel = new V1ComponentModel();
            componentModel.setName(processName);
            componentModel.addService((ComponentServiceModel)serviceModel);
            compositeModel.addComponent((ComponentModel)componentModel);
            V1BPMComponentImplementationModel bciModel = new V1BPMComponentImplementationModel();
            String processDefinition = process.definition();
            if (UNDEFINED.equals(processDefinition)) {
                processDefinition = "META-INF/" + processName + ".bpmn";
            }
            SimpleResource procDefRes = new SimpleResource(processDefinition);
            String procDefResType = process.definitionType();
            if (!UNDEFINED.equals(procDefResType)) {
                procDefRes.setType(ResourceType.valueOf((String)procDefResType));
            }
            bciModel.setProcessDefinition((Resource)procDefRes);
            String processId = process.id();
            if (UNDEFINED.equals(processId)) {
                processId = processName;
            }
            bciModel.setProcessId(processId);
            if (process.agent()) {
                bciModel.setAgent(true);
            }
            if (!UNDEFINED.equals(messageContentInName = process.messageContentInName())) {
                bciModel.setMessageContentInName(messageContentInName);
            }
            if (!UNDEFINED.equals(messageContentOutName = process.messageContentOutName())) {
                bciModel.setMessageContentOutName(messageContentOutName);
            }
            JavaService javaService = JavaService.fromClass((Class)processInterface);
            for (Method method : processClass.getDeclaredMethods()) {
                ServiceOperation srvOper;
                ProcessActionType pat = null;
                String eventType = null;
                if (START_PROCESS_FILTER.matches(method)) {
                    if (SIGNAL_EVENT_FILTER.matches(method) || ABORT_PROCESS_INSTANCE_FILTER.matches(method)) {
                        throw new IOException(method.getName() + " " + FILTER_ERR_MSG);
                    }
                    pat = ProcessActionType.START_PROCESS;
                } else if (SIGNAL_EVENT_FILTER.matches(method)) {
                    if (ABORT_PROCESS_INSTANCE_FILTER.matches(method)) {
                        throw new IOException(method.getName() + " " + FILTER_ERR_MSG);
                    }
                    pat = ProcessActionType.SIGNAL_EVENT;
                    eventType = method.getAnnotation(SignalEvent.class).value();
                    if (UNDEFINED.equals(eventType)) {
                        eventType = method.getName();
                    }
                } else if (ABORT_PROCESS_INSTANCE_FILTER.matches(method)) {
                    pat = ProcessActionType.ABORT_PROCESS_INSTANCE;
                }
                if (pat == null || (srvOper = javaService.getOperation(method.getName())) == null) continue;
                ProcessActionModel pam = new V1ProcessActionModel().setName(srvOper.getName()).setType(pat);
                if (eventType != null) {
                    pam.setEventType(eventType);
                }
                bciModel.addProcessAction(pam);
            }
            Audit audit = processClass.getAnnotation(Audit.class);
            if (audit != null) {
                V1AuditModel aModel = new V1AuditModel(bciModel.getModelConfiguration().getQName().getNamespaceURI());
                aModel.setType(audit.type());
                int interval = audit.interval();
                if (interval != -1) {
                    aModel.setInterval(Integer.valueOf(interval));
                }
                if (!UNDEFINED.equals(audit.log())) {
                    aModel.setLog(audit.log());
                }
                bciModel.setAudit((AuditModel)aModel);
            }
            bciModel.addTaskHandler(new V1TaskHandlerModel().setClazz(SwitchYardServiceTaskHandler.class).setName("SwitchYard Service"));
            for (Class<? extends TaskHandler> taskHandlerClass : process.taskHandlers()) {
                if (Process.UndefinedTaskHandler.class.equals(taskHandlerClass) || SwitchYardServiceTaskHandler.class.equals(taskHandlerClass)) continue;
                TaskHandler taskHandler = (TaskHandler)Construction.construct(taskHandlerClass);
                bciModel.addTaskHandler(new V1TaskHandlerModel().setClazz(taskHandlerClass).setName(taskHandler.getName()));
            }
            for (String location : process.resources()) {
                if (UNDEFINED.equals(location)) continue;
                bciModel.addResource(new V1ResourceModel("urn:switchyard-component-bpm:config:1.0").setLocation(location));
            }
            componentModel.setImplementation((ComponentImplementationModel)bciModel);
        }
        if (!compositeModel.getModelChildren().isEmpty()) {
            switchyardModel.setComposite((CompositeModel)compositeModel);
        }
        return new ScannerOutput().setModel((Model)switchyardModel);
    }
}

