/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.task.drools;

import java.util.Map;
import org.drools.runtime.process.ProcessRuntime;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.switchyard.component.bpm.task.Task;
import org.switchyard.component.bpm.task.TaskState;

public class DroolsTask
implements Task {
    private final ProcessRuntime _processRuntime;
    private final WorkItem _workItem;

    public DroolsTask(ProcessRuntime processRuntime, WorkItem workItem) {
        this._processRuntime = processRuntime;
        this._workItem = workItem;
    }

    ProcessRuntime getProcessRuntime() {
        return this._processRuntime;
    }

    WorkItem getWorkItem() {
        return this._workItem;
    }

    @Override
    public Long getId() {
        return this._workItem.getId();
    }

    @Override
    public String getName() {
        return this._workItem.getName();
    }

    @Override
    public TaskState getState() {
        int state = this._workItem.getState();
        switch (state) {
            case 0: {
                return TaskState.PENDING;
            }
            case 1: {
                return TaskState.ACTIVE;
            }
            case 2: {
                return TaskState.COMPLETED;
            }
            case 3: {
                return TaskState.ABORTED;
            }
        }
        return null;
    }

    @Override
    public Object getParameter(String name) {
        return this._workItem.getParameter(name);
    }

    @Override
    public Map<String, Object> getParameters() {
        return this._workItem.getParameters();
    }

    @Override
    public Object getResult(String name) {
        return this._workItem.getResult(name);
    }

    @Override
    public Map<String, Object> getResults() {
        return this._workItem.getResults();
    }

    @Override
    public Long getProcessInstanceId() {
        return this._workItem.getProcessInstanceId();
    }

    @Override
    public Object getProcessInstanceVariable(String name) {
        return this.getProcessInstance().getVariable(name);
    }

    @Override
    public Task setProcessInstanceVariable(String name, Object value) {
        this.getProcessInstance().setVariable(name, value);
        return this;
    }

    private WorkflowProcessInstance getProcessInstance() {
        return (WorkflowProcessInstance)this._processRuntime.getProcessInstance(this._workItem.getProcessInstanceId());
    }
}

