/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.config.model;

import java.io.IOException;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import org.switchyard.common.io.resource.Resource;
import org.switchyard.common.io.resource.ResourceType;
import org.switchyard.common.io.resource.SimpleResource;
import org.switchyard.common.type.classpath.ClasspathScanner;
import org.switchyard.common.type.classpath.Filter;
import org.switchyard.common.type.classpath.IsAnnotationPresentFilter;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.component.bpm.AbortProcessInstance;
import org.switchyard.component.bpm.Process;
import org.switchyard.component.bpm.SignalEvent;
import org.switchyard.component.bpm.StartProcess;
import org.switchyard.component.bpm.common.ProcessActionType;
import org.switchyard.component.bpm.config.model.ProcessActionModel;
import org.switchyard.component.bpm.config.model.v1.V1BpmComponentImplementationModel;
import org.switchyard.component.bpm.config.model.v1.V1ProcessActionModel;
import org.switchyard.component.bpm.config.model.v1.V1TaskHandlerModel;
import org.switchyard.component.bpm.task.SwitchYardServiceTaskHandler;
import org.switchyard.component.bpm.task.TaskHandler;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.Scanner;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.ScannerOutput;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentServiceInterfaceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.v1.V1ComponentModel;
import org.switchyard.config.model.composite.v1.V1ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1CompositeModel;
import org.switchyard.config.model.composite.v1.V1JavaComponentServiceInterfaceModel;
import org.switchyard.config.model.resource.v1.V1ResourceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.switchyard.v1.V1SwitchYardModel;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.metadata.java.JavaService;

public class BpmSwitchYardScanner
implements Scanner<SwitchYardModel> {
    private static final IsAnnotationPresentFilter PROCESS_FILTER = new IsAnnotationPresentFilter(Process.class);
    private static final IsAnnotationPresentFilter START_PROCESS_FILTER = new IsAnnotationPresentFilter(StartProcess.class);
    private static final IsAnnotationPresentFilter SIGNAL_EVENT_FILTER = new IsAnnotationPresentFilter(SignalEvent.class);
    private static final IsAnnotationPresentFilter ABORT_PROCESS_INSTANCE_FILTER = new IsAnnotationPresentFilter(AbortProcessInstance.class);
    private static final String INTERFACE_ERR_MSG = " is a class. @Process only allowed on interfaces.";
    private static final String FILTER_ERR_MSG = " is in error. @StartProcess, @SignalEvent and @AbortProcessInstance cannot co-exist on the same method.";

    public ScannerOutput<SwitchYardModel> scan(ScannerInput<SwitchYardModel> input) throws IOException {
        V1SwitchYardModel switchyardModel = new V1SwitchYardModel();
        V1CompositeModel compositeModel = new V1CompositeModel();
        compositeModel.setName(input.getName());
        switchyardModel.setComposite((CompositeModel)compositeModel);
        ClasspathScanner processScanner = new ClasspathScanner((Filter)PROCESS_FILTER);
        for (URL url : input.getURLs()) {
            processScanner.scan(url);
        }
        List processClasses = PROCESS_FILTER.getMatchedTypes();
        for (Class processClass : processClasses) {
            Process process = processClass.getAnnotation(Process.class);
            Class processInterface = process.value();
            if (Process.UndefinedProcessInterface.class.equals(processInterface)) {
                processInterface = processClass;
            }
            if (!processInterface.isInterface()) {
                throw new IOException(processInterface.getName() + INTERFACE_ERR_MSG);
            }
            String processName = processInterface.getSimpleName();
            V1JavaComponentServiceInterfaceModel csiModel = new V1JavaComponentServiceInterfaceModel();
            csiModel.setInterface(processInterface.getName());
            V1ComponentServiceModel serviceModel = new V1ComponentServiceModel();
            serviceModel.setInterface((ComponentServiceInterfaceModel)csiModel);
            serviceModel.setName(processName);
            V1ComponentModel componentModel = new V1ComponentModel();
            componentModel.setName(processName);
            componentModel.addService((ComponentServiceModel)serviceModel);
            compositeModel.addComponent((ComponentModel)componentModel);
            V1BpmComponentImplementationModel bciModel = new V1BpmComponentImplementationModel();
            String processDefinition = process.definition();
            if ("".equals(processDefinition)) {
                processDefinition = "META-INF/" + processName + ".bpmn";
            }
            bciModel.setProcessDefinition((Resource)new SimpleResource(processDefinition, process.definitionType()));
            String processId = process.id();
            if ("".equals(processId)) {
                processId = processName;
            }
            bciModel.setProcessId(processId);
            JavaService javaService = JavaService.fromClass((Class)processInterface);
            for (Method method : processClass.getDeclaredMethods()) {
                ServiceOperation srvOper;
                ProcessActionType pat = null;
                String eventType = null;
                if (START_PROCESS_FILTER.matches(method)) {
                    if (SIGNAL_EVENT_FILTER.matches(method) || ABORT_PROCESS_INSTANCE_FILTER.matches(method)) {
                        throw new IOException(method.getName() + " " + FILTER_ERR_MSG);
                    }
                    pat = ProcessActionType.START_PROCESS;
                } else if (SIGNAL_EVENT_FILTER.matches(method)) {
                    if (ABORT_PROCESS_INSTANCE_FILTER.matches(method)) {
                        throw new IOException(method.getName() + " " + FILTER_ERR_MSG);
                    }
                    pat = ProcessActionType.SIGNAL_EVENT;
                    eventType = method.getAnnotation(SignalEvent.class).value();
                    if ("".equals(eventType)) {
                        eventType = method.getName();
                    }
                } else if (ABORT_PROCESS_INSTANCE_FILTER.matches(method)) {
                    pat = ProcessActionType.ABORT_PROCESS_INSTANCE;
                }
                if (pat == null || (srvOper = javaService.getOperation(method.getName())) == null) continue;
                ProcessActionModel pam = new V1ProcessActionModel().setName(srvOper.getName()).setType(pat);
                if (eventType != null) {
                    pam.setEventType(eventType);
                }
                bciModel.addProcessAction(pam);
            }
            bciModel.addTaskHandler(new V1TaskHandlerModel().setClazz(SwitchYardServiceTaskHandler.class).setName("SwitchYard Service"));
            for (GenericDeclaration genericDeclaration : process.taskHandlers()) {
                if (Process.UndefinedTaskHandler.class.equals((Object)genericDeclaration) || SwitchYardServiceTaskHandler.class.equals((Object)genericDeclaration)) continue;
                TaskHandler taskHandler = (TaskHandler)Construction.construct((Class)genericDeclaration);
                bciModel.addTaskHandler(new V1TaskHandlerModel().setClazz((Class<? extends TaskHandler>)genericDeclaration).setName(taskHandler.getName()));
            }
            for (GenericDeclaration genericDeclaration : process.resources()) {
                if (Process.UndefinedResource.class.equals((Object)genericDeclaration)) continue;
                Resource resource = (Resource)Construction.construct((Class)genericDeclaration);
                String location = resource.getLocation();
                ResourceType type = resource.getType();
                bciModel.addResource(new V1ResourceModel().setLocation(location).setType(type));
            }
            componentModel.setImplementation((ComponentImplementationModel)bciModel);
        }
        return new ScannerOutput().setModel((Model)switchyardModel);
    }
}

