/*
 * Decompiled with CFR 0.152.
 */
package io.github.gitbucket.markedj;

import io.github.gitbucket.markedj.Options;
import io.github.gitbucket.markedj.Utils;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Renderer {
    protected Options options;

    public Renderer(Options options) {
        this.options = options;
    }

    public String code(String code, String lang, boolean escaped) {
        if (lang != null) {
            StringBuilder sb = new StringBuilder();
            if (Utils.escape(lang, true).equals("math")) {
                sb.append("<div class=\"" + this.options.getLangPrefix() + Utils.escape(lang, true) + " hljs\">\n$$\n");
                sb.append(code);
                sb.append("\n$$</div>\n");
            } else {
                sb.append("<pre><code class=\"" + this.options.getLangPrefix() + Utils.escape(lang, true) + " hljs\">");
                if (escaped) {
                    sb.append(code);
                } else {
                    sb.append(Utils.escape(code, true));
                }
                sb.append("\n</code></pre>\n");
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<pre><code class=\"hljs\">");
        if (escaped) {
            sb.append(code);
        } else {
            sb.append(Utils.escape(code, true));
        }
        sb.append("\n</code></pre>\n");
        return sb.toString();
    }

    public String mathBlock(String code) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div>\n");
        sb.append(code);
        sb.append("\n</div>\n");
        return sb.toString();
    }

    public String blockquote(String quote) {
        return "<blockquote>\n" + quote + "</blockquote>\n";
    }

    public String html(String html) {
        return html;
    }

    public String heading(String text, int level, String raw) {
        if (this.options.isHeaderIdSequential()) {
            return "<h" + level + " id=\"" + this.options.getHeaderPrefix() + this.options.SequentialId() + "\">" + text + "</h" + level + ">\n";
        }
        return "<h" + level + " id=\"" + this.options.getHeaderPrefix() + raw.toLowerCase().replaceAll("[^\\w]+", "-") + "\">" + text + "</h" + level + ">\n";
    }

    public String hr() {
        if (this.options.isXhtml()) {
            return "<hr/>\n";
        }
        return "<hr>\n";
    }

    public String list(String body, boolean ordered) {
        String listType = ordered ? "ol" : "ul";
        return "<" + listType + ">\n" + body + "</" + listType + ">\n";
    }

    public String listitem(String text) {
        return "<li>" + text + "</li>\n";
    }

    public String paragraph(String text) {
        return "<p>" + text + "</p>\n";
    }

    public String table(String header, String body) {
        return "<table>\n<thead>\n" + header + "</thead>\n<tbody>\n" + body + "</tbody>\n</table>\n";
    }

    public String tablerow(String content) {
        return "<tr>\n" + content + "</tr>\n";
    }

    public String tablecell(String content, TableCellFlags flags) {
        String cellType = flags.isHeader() ? "th" : "td";
        String align = flags.getAlign();
        if (align != null) {
            return "<" + cellType + " style=\"text-align: " + align + "\">" + content + "</" + cellType + ">\n";
        }
        return "<" + cellType + ">" + content + "</" + cellType + ">\n";
    }

    public String strong(String text) {
        return "<strong>" + text + "</strong>";
    }

    public String em(String text) {
        return "<em>" + text + "</em>";
    }

    public String codespan(String text) {
        return "<code class=\"hljs\">" + text + "</code>";
    }

    public String br() {
        if (this.options.isXhtml()) {
            return "<br/>";
        }
        return "<br>";
    }

    public String del(String text) {
        return "<del>" + text + "</del>";
    }

    public String oembed(String href) {
        return "<a class=\"oembed\" href=\"" + href + "\">" + href + "</a>";
    }

    public String slide(String file) {
        String fileNo;
        String attribute = null;
        if (file.contains(" ")) {
            fileNo = file.substring(0, file.indexOf(" ")).trim();
            attribute = file.substring(file.indexOf(" ")).trim();
        } else {
            fileNo = file;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<var class=\"slideshow\" id=\"slide-").append(fileNo).append("\" slide=\"").append(fileNo).append("\"");
        if (attribute != null && attribute.length() > 0) {
            builder.append(" ").append(attribute);
        }
        builder.append(">").append(fileNo).append("</var>");
        return builder.toString();
    }

    public Object internallink(String noTerm) {
        String no = noTerm.substring("#".length());
        return "<var class=\"internallink\" id=\"internallink-" + no + "\" internallink=\"" + no + "\">" + noTerm + "</var>";
    }

    public String footnoteref(String key) {
        return "<sup class=\"footnote-ref\" id=\"fnref-" + Utils.escape(key) + "\"><a href=\"#fn-" + Utils.escape(key) + "\">" + key + "</a></sup>";
    }

    public String footnote(Map<String, String> notes) {
        String out = "<ol class=\"footnotes\">";
        for (Map.Entry<String, String> noteEntry : notes.entrySet()) {
            String key = noteEntry.getKey();
            String text = noteEntry.getValue();
            out = out + "<li id=\"fn-" + key + "\">";
            out = out + text.trim();
            out = out + "<a href=\"#fnref-" + key + "\">&#8617;</a>";
            out = out + "</li>";
        }
        out = out + "</ol>";
        return out;
    }

    public String link(String href, String title, String text) {
        if (this.options.isSanitize()) {
            // empty if block
        }
        String titleAttr = "";
        if (title != null) {
            titleAttr = " title=\"" + title + "\"";
        }
        boolean external = false;
        if (href.startsWith("http")) {
            external = true;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<a href=\"").append(href).append("\"").append(titleAttr);
        if (external && this.options.isLinkTargetBlank()) {
            builder.append(" target=\"_blank\"");
        }
        builder.append(">").append(text).append("</a>");
        return builder.toString();
    }

    public String image(String href, String title, String text) {
        String titleAttr = "";
        if (title != null) {
            titleAttr = " title=\"" + title + "\"";
        }
        String width = null;
        if (text != null) {
            String[] strs;
            String regex = "(.*%)";
            Pattern p = Pattern.compile(regex);
            for (String string : strs = text.split("\\s")) {
                Matcher m = p.matcher(string);
                if (!m.find()) continue;
                width = m.group(0).trim();
                break;
            }
            if (width != null) {
                text = text.replace(width, "").trim();
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<img src=\"" + href + "\" alt=\"" + text + "\"" + titleAttr);
        if (width != null) {
            builder.append(" width=\"" + width + "\"");
        }
        if (this.options.isXhtml()) {
            builder.append("/>");
        } else {
            builder.append(">");
        }
        return builder.toString();
    }

    public String nolink(String text) {
        return Utils.escape(text);
    }

    public String text(String text) {
        return text;
    }

    public static class TableCellFlags {
        private boolean header;
        private String align;

        public TableCellFlags(boolean header, String align) {
            this.header = header;
            this.align = align;
        }

        public boolean isHeader() {
            return this.header;
        }

        public String getAlign() {
            return this.align;
        }
    }
}

