/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.walletsdk.recovery;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.Signature;
import org.stellar.walletsdk.AccountThreshold;
import org.stellar.walletsdk.exception.ValidationException;
import org.stellar.walletsdk.horizon.transaction.CommonTransactionBuilder;
import org.stellar.walletsdk.recovery.AccountSigner;
import org.stellar.walletsdk.recovery.RecoveryKt;
import org.stellar.walletsdk.recovery.RecoveryServer;
import org.stellar.walletsdk.recovery.RecoveryServerKey;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a-\u0010\b\u001a\u00020\t*\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\n2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\r\u0010\u000e\u001aT\u0010\u000f\u001a\u0002H\u0010\"\u000e\b\u0000\u0010\u0010\u0018\u0001*\u0006\u0012\u0002\b\u00030\u0011*\u0002H\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u001a\b\b\u0010\u0017\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018H\u0082\b\u00a2\u0006\u0002\u0010\u001a\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"log", "Lmu/KLogger;", "createDecoratedSignature", "Lorg/stellar/sdk/xdr/DecoratedSignature;", "signatureAddress", "", "decodedSignature", "", "getServer", "Lorg/stellar/walletsdk/recovery/RecoveryServer;", "", "Lorg/stellar/walletsdk/recovery/RecoveryServerKey;", "key", "getServer-r1sDgNc", "(Ljava/util/Map;Ljava/lang/String;)Lorg/stellar/walletsdk/recovery/RecoveryServer;", "register", "T", "Lorg/stellar/walletsdk/horizon/transaction/CommonTransactionBuilder;", "accountSigner", "", "Lorg/stellar/walletsdk/recovery/AccountSigner;", "accountThreshold", "Lorg/stellar/walletsdk/AccountThreshold;", "builderExtra", "Lkotlin/Function1;", "", "(Lorg/stellar/walletsdk/horizon/transaction/CommonTransactionBuilder;Ljava/util/List;Lorg/stellar/walletsdk/AccountThreshold;Lkotlin/jvm/functions/Function1;)Lorg/stellar/walletsdk/horizon/transaction/CommonTransactionBuilder;", "wallet-sdk"})
@SourceDebugExtension(value={"SMAP\nRecovery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Recovery.kt\norg/stellar/walletsdk/recovery/RecoveryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,220:1\n1855#2,2:221\n*S KotlinDebug\n*F\n+ 1 Recovery.kt\norg/stellar/walletsdk/recovery/RecoveryKt\n*L\n194#1:221,2\n*E\n"})
public final class RecoveryKt {
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);

    private static final /* synthetic */ <T extends CommonTransactionBuilder<?>> T register(T $this$register, List<AccountSigner> accountSigner, AccountThreshold accountThreshold, Function1<? super CommonTransactionBuilder<?>, Unit> builderExtra) {
        block1: {
            boolean $i$f$register = false;
            $this$register.lockAccountMasterKey();
            Iterable $this$forEach$iv = accountSigner;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AccountSigner it = (AccountSigner)element$iv;
                boolean bl = false;
                $this$register.addAccountSigner(it.getAddress(), it.getWeight());
            }
            $this$register.setThreshold(accountThreshold.getLow(), accountThreshold.getMedium(), accountThreshold.getHigh());
            Function1<? super CommonTransactionBuilder<?>, Unit> function1 = builderExtra;
            if (function1 == null) break block1;
            function1.invoke($this$register);
        }
        return $this$register;
    }

    @NotNull
    public static final DecoratedSignature createDecoratedSignature(@NotNull String signatureAddress, @NotNull byte[] decodedSignature) {
        Intrinsics.checkNotNullParameter((Object)signatureAddress, (String)"signatureAddress");
        Intrinsics.checkNotNullParameter((Object)decodedSignature, (String)"decodedSignature");
        Signature signature = new Signature();
        signature.setSignature(decodedSignature);
        DecoratedSignature decoratedSig = new DecoratedSignature();
        decoratedSig.setSignature(signature);
        decoratedSig.setHint(KeyPair.fromAccountId((String)signatureAddress).getSignatureHint());
        return decoratedSig;
    }

    @NotNull
    public static final RecoveryServer getServer-r1sDgNc(@NotNull Map<RecoveryServerKey, RecoveryServer> $this$getServer_u2dr1sDgNc, @NotNull String key) {
        Intrinsics.checkNotNullParameter($this$getServer_u2dr1sDgNc, (String)"$this$getServer");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        RecoveryServer recoveryServer = $this$getServer_u2dr1sDgNc.get(RecoveryServerKey.box-impl(key));
        if (recoveryServer == null) {
            throw new ValidationException("Server with key " + RecoveryServerKey.toString-impl(key) + " was not found");
        }
        return recoveryServer;
    }

    public static final /* synthetic */ KLogger access$getLog$p() {
        return log;
    }
}

