/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.walletsdk.horizon.transaction;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.ULong;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stellar.sdk.Memo;
import org.stellar.sdk.Network;
import org.stellar.sdk.Operation;
import org.stellar.sdk.PaymentOperation;
import org.stellar.sdk.TimeBounds;
import org.stellar.sdk.Transaction;
import org.stellar.sdk.TransactionBuilderAccount;
import org.stellar.sdk.TransactionPreconditions;
import org.stellar.sdk.responses.AccountResponse;
import org.stellar.walletsdk.Config;
import org.stellar.walletsdk.anchor.MemoType;
import org.stellar.walletsdk.anchor.TransactionStatus;
import org.stellar.walletsdk.anchor.WithdrawalTransaction;
import org.stellar.walletsdk.asset.AssetIdKt;
import org.stellar.walletsdk.asset.StellarAssetId;
import org.stellar.walletsdk.exception.InvalidStartingBalanceException;
import org.stellar.walletsdk.exception.ValidationException;
import org.stellar.walletsdk.horizon.AccountKeyPair;
import org.stellar.walletsdk.horizon.transaction.CommonTransactionBuilder;
import org.stellar.walletsdk.horizon.transaction.SponsoringBuilder;
import org.stellar.walletsdk.util.UtilKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001BD\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0017J\u0006\u0010\u001c\u001a\u00020\u001dJ%\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\u0007\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\"\u0010#J\u001a\u0010$\u001a\u00020\u00002\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tJ3\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020 2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010 2\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020*0)\u00a2\u0006\u0002\b+J\u001e\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u000bJ\u0016\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u0002032\u0006\u0010.\u001a\u00020/R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00064"}, d2={"Lorg/stellar/walletsdk/horizon/transaction/TransactionBuilder;", "Lorg/stellar/walletsdk/horizon/transaction/CommonTransactionBuilder;", "cfg", "Lorg/stellar/walletsdk/Config;", "sourceAccount", "Lorg/stellar/sdk/responses/AccountResponse;", "baseFee", "Lkotlin/ULong;", "memo", "Lkotlin/Pair;", "Lorg/stellar/walletsdk/anchor/MemoType;", "", "timeBounds", "Lorg/stellar/sdk/TimeBounds;", "(Lorg/stellar/walletsdk/Config;Lorg/stellar/sdk/responses/AccountResponse;Lkotlin/ULong;Lkotlin/Pair;Lorg/stellar/sdk/TimeBounds;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "builder", "Lorg/stellar/sdk/TransactionBuilder;", "maxBaseFeeInStroops", "", "network", "Lorg/stellar/sdk/Network;", "operations", "", "Lorg/stellar/sdk/Operation;", "getOperations", "()Ljava/util/List;", "addOperation", "operation", "build", "Lorg/stellar/sdk/Transaction;", "createAccount", "newAccount", "Lorg/stellar/walletsdk/horizon/AccountKeyPair;", "startingBalance", "createAccount-2TYgG_w", "(Lorg/stellar/walletsdk/horizon/AccountKeyPair;J)Lorg/stellar/walletsdk/horizon/transaction/TransactionBuilder;", "setMemo", "sponsoring", "sponsorAccount", "sponsoredAccount", "body", "Lkotlin/Function1;", "Lorg/stellar/walletsdk/horizon/transaction/SponsoringBuilder;", "Lkotlin/ExtensionFunctionType;", "transfer", "destinationAddress", "assetId", "Lorg/stellar/walletsdk/asset/StellarAssetId;", "amount", "transferWithdrawalTransaction", "transaction", "Lorg/stellar/walletsdk/anchor/WithdrawalTransaction;", "wallet-sdk"})
@SourceDebugExtension(value={"SMAP\nTransactionBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionBuilder.kt\norg/stellar/walletsdk/horizon/transaction/TransactionBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 CommonTransactionBuilder.kt\norg/stellar/walletsdk/horizon/transaction/CommonTransactionBuilder\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1#2:142\n17#3,2:143\n17#3,2:145\n17#3,2:147\n1855#4,2:149\n*S KotlinDebug\n*F\n+ 1 TransactionBuilder.kt\norg/stellar/walletsdk/horizon/transaction/TransactionBuilder\n*L\n83#1:143,2\n101#1:145,2\n110#1:147,2\n118#1:149,2\n*E\n"})
public final class TransactionBuilder
extends CommonTransactionBuilder<TransactionBuilder> {
    @NotNull
    private final Network network;
    private final long maxBaseFeeInStroops;
    @NotNull
    private final List<Operation> operations;
    @NotNull
    private final org.stellar.sdk.TransactionBuilder builder;

    private TransactionBuilder(Config cfg, AccountResponse sourceAccount, ULong baseFee, Pair<? extends MemoType, String> memo, TimeBounds timeBounds) {
        block1: {
            Pair<? extends MemoType, String> pair;
            Intrinsics.checkNotNullParameter((Object)cfg, (String)"cfg");
            Intrinsics.checkNotNullParameter((Object)sourceAccount, (String)"sourceAccount");
            String string = sourceAccount.getAccountId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceAccount.accountId");
            super(string);
            this.network = cfg.getStellar().getNetwork();
            this.maxBaseFeeInStroops = cfg.getStellar().getBaseFee-s-VKNKU();
            this.operations = new ArrayList();
            ULong uLong = baseFee;
            org.stellar.sdk.TransactionBuilder transactionBuilder = new org.stellar.sdk.TransactionBuilder((TransactionBuilderAccount)sourceAccount, this.network).setBaseFee(uLong != null ? uLong.unbox-impl() : this.maxBaseFeeInStroops);
            TransactionPreconditions.TransactionPreconditionsBuilder transactionPreconditionsBuilder = TransactionPreconditions.builder();
            TimeBounds timeBounds2 = timeBounds;
            if (timeBounds2 == null) {
                timeBounds2 = UtilKt.toTimeBounds(cfg.getStellar().getDefaultTimeout());
            }
            org.stellar.sdk.TransactionBuilder transactionBuilder2 = transactionBuilder.addPreconditions(transactionPreconditionsBuilder.timeBounds(timeBounds2).build());
            Intrinsics.checkNotNullExpressionValue((Object)transactionBuilder2, (String)"SdkBuilder(sourceAccount\u2026         .build()\n      )");
            this.builder = transactionBuilder2;
            Pair<? extends MemoType, String> pair2 = memo;
            if (pair2 == null) break block1;
            Pair<? extends MemoType, String> it = pair = pair2;
            boolean bl = false;
            this.builder.addMemo((Memo)((MemoType)((Object)it.getFirst())).getMapper().invoke(it.getSecond()));
        }
    }

    @Override
    @NotNull
    public List<Operation> getOperations() {
        return this.operations;
    }

    @NotNull
    public final TransactionBuilder setMemo(@NotNull Pair<? extends MemoType, String> memo) {
        Intrinsics.checkNotNullParameter(memo, (String)"memo");
        this.builder.addMemo((Memo)((MemoType)((Object)memo.getFirst())).getMapper().invoke(memo.getSecond()));
        return this;
    }

    @NotNull
    public final TransactionBuilder sponsoring(@NotNull AccountKeyPair sponsorAccount, @Nullable AccountKeyPair sponsoredAccount, @NotNull Function1<? super SponsoringBuilder, SponsoringBuilder> body) {
        Intrinsics.checkNotNullParameter((Object)sponsorAccount, (String)"sponsorAccount");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Object object = sponsoredAccount;
        if (object == null || (object = object.getAddress()) == null) {
            object = this.getSourceAddress();
        }
        ((SponsoringBuilder)body.invoke((Object)new SponsoringBuilder((String)object, sponsorAccount, this.getOperations()))).stopSponsoring$wallet_sdk();
        return this;
    }

    public static /* synthetic */ TransactionBuilder sponsoring$default(TransactionBuilder transactionBuilder, AccountKeyPair accountKeyPair, AccountKeyPair accountKeyPair2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            accountKeyPair2 = null;
        }
        return transactionBuilder.sponsoring(accountKeyPair, accountKeyPair2, (Function1<? super SponsoringBuilder, SponsoringBuilder>)function1);
    }

    @NotNull
    public final TransactionBuilder createAccount-2TYgG_w(@NotNull AccountKeyPair newAccount, long startingBalance) {
        Intrinsics.checkNotNullParameter((Object)newAccount, (String)"newAccount");
        CommonTransactionBuilder this_$iv = this;
        boolean $i$f$building$wallet_sdk = false;
        List<Operation> list = this_$iv.getOperations();
        boolean bl = false;
        if (Long.compareUnsigned(startingBalance, ULong.constructor-impl((long)(1L & 0xFFFFFFFFL))) < 0) {
            throw InvalidStartingBalanceException.INSTANCE;
        }
        list.add((Operation)this.doCreateAccount-z13BHRw(newAccount, startingBalance, this.getSourceAddress()));
        return (TransactionBuilder)this_$iv;
    }

    public static /* synthetic */ TransactionBuilder createAccount-2TYgG_w$default(TransactionBuilder transactionBuilder, AccountKeyPair accountKeyPair, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 1L;
        }
        return transactionBuilder.createAccount-2TYgG_w(accountKeyPair, l);
    }

    @NotNull
    public final TransactionBuilder transfer(@NotNull String destinationAddress, @NotNull StellarAssetId assetId, @NotNull String amount) {
        Intrinsics.checkNotNullParameter((Object)destinationAddress, (String)"destinationAddress");
        Intrinsics.checkNotNullParameter((Object)assetId, (String)"assetId");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        CommonTransactionBuilder this_$iv = this;
        boolean $i$f$building$wallet_sdk = false;
        List<Operation> list = this_$iv.getOperations();
        boolean bl = false;
        PaymentOperation paymentOperation = new PaymentOperation.Builder(destinationAddress, AssetIdKt.toAsset(assetId), amount).build();
        Intrinsics.checkNotNullExpressionValue((Object)paymentOperation, (String)"Builder(destinationAddre\u2026oAsset(), amount).build()");
        list.add((Operation)paymentOperation);
        return (TransactionBuilder)this_$iv;
    }

    @NotNull
    public final TransactionBuilder addOperation(@NotNull Operation operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        CommonTransactionBuilder this_$iv = this;
        boolean $i$f$building$wallet_sdk = false;
        List<Operation> list = this_$iv.getOperations();
        boolean bl = false;
        list.add(operation);
        return (TransactionBuilder)this_$iv;
    }

    @NotNull
    public final Transaction build() {
        Iterable $this$forEach$iv = this.getOperations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Operation it = (Operation)element$iv;
            boolean bl = false;
            this.builder.addOperation(it);
        }
        Transaction transaction2 = this.builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)transaction2, (String)"builder.build()");
        return transaction2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TransactionBuilder transferWithdrawalTransaction(@NotNull WithdrawalTransaction transaction2, @NotNull StellarAssetId assetId) {
        String string;
        TransactionBuilder transactionBuilder;
        block3: {
            block2: {
                void it;
                Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
                Intrinsics.checkNotNullParameter((Object)assetId, (String)"assetId");
                UtilKt.requireStatus(transaction2, TransactionStatus.PENDING_USER_TRANSFER_START);
                transactionBuilder = this;
                string = transaction2.getWithdrawalMemo();
                if (string == null) break block2;
                String string2 = string;
                TransactionBuilder transactionBuilder2 = transactionBuilder;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)((Object)transaction2.getWithdrawalMemoType()), (Object)it);
                transactionBuilder = transactionBuilder2;
                string = pair;
                if (pair != null) break block3;
            }
            throw new ValidationException("Missing withdrawal_memo in the transaction");
        }
        return transactionBuilder.setMemo((Pair<? extends MemoType, String>)string).transfer(transaction2.getWithdrawAnchorAccount(), assetId, transaction2.getAmountIn());
    }

    public /* synthetic */ TransactionBuilder(Config cfg, AccountResponse sourceAccount, ULong baseFee, Pair memo, TimeBounds timeBounds, DefaultConstructorMarker $constructor_marker) {
        this(cfg, sourceAccount, baseFee, (Pair<? extends MemoType, String>)memo, timeBounds);
    }
}

