/*
 * Decompiled with CFR 0.152.
 */
package org.statefulj.persistence.memory;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.statefulj.common.utils.ReflectionUtils;
import org.statefulj.fsm.Persister;
import org.statefulj.fsm.StaleStateException;
import org.statefulj.persistence.annotations.State;

public class MemoryPersisterImpl<T>
implements Persister<T> {
    private final Map<String, org.statefulj.fsm.model.State<T>> states = new HashMap<String, org.statefulj.fsm.model.State<T>>();
    private org.statefulj.fsm.model.State<T> start;
    private String stateFieldName;
    private volatile Field stateField;

    public MemoryPersisterImpl(Collection<org.statefulj.fsm.model.State<T>> states, org.statefulj.fsm.model.State<T> start) {
        this.setStart(start);
        this.setStates(states);
    }

    public MemoryPersisterImpl(List<org.statefulj.fsm.model.State<T>> states, org.statefulj.fsm.model.State<T> start, String stateFieldName) {
        this(states, start);
        this.stateFieldName = stateFieldName;
    }

    public MemoryPersisterImpl(T stateful, List<org.statefulj.fsm.model.State<T>> states, org.statefulj.fsm.model.State<T> start) {
        this(states, start);
        this.setCurrent(stateful, start);
    }

    public MemoryPersisterImpl(T stateful, List<org.statefulj.fsm.model.State<T>> states, org.statefulj.fsm.model.State<T> start, String stateFieldName) {
        this(states, start, stateFieldName);
        this.setCurrent(stateful, start);
    }

    public synchronized Collection<org.statefulj.fsm.model.State<T>> getStates() {
        return this.states.values();
    }

    public synchronized org.statefulj.fsm.model.State<T> addState(org.statefulj.fsm.model.State<T> state) {
        return this.states.put(state.getName(), state);
    }

    public org.statefulj.fsm.model.State<T> removeState(org.statefulj.fsm.model.State<T> state) {
        return this.removeState(state.getName());
    }

    public synchronized org.statefulj.fsm.model.State<T> removeState(String name) {
        return this.states.remove(name);
    }

    public synchronized void setStates(Collection<org.statefulj.fsm.model.State<T>> states) {
        this.states.clear();
        for (org.statefulj.fsm.model.State<T> state : states) {
            this.states.put(state.getName(), state);
        }
    }

    public org.statefulj.fsm.model.State<T> getStart() {
        return this.start;
    }

    public void setStart(org.statefulj.fsm.model.State<T> start) {
        this.start = start;
    }

    public String getStateFieldName() {
        return this.stateFieldName;
    }

    public void setStateFieldName(String stateFieldName) {
        this.stateFieldName = stateFieldName;
    }

    @Override
    public org.statefulj.fsm.model.State<T> getCurrent(T stateful) {
        try {
            String key = (String)this.getStateField(stateful).get(stateful);
            org.statefulj.fsm.model.State<T> state = key != null ? this.states.get(key) : null;
            return state != null ? state : this.start;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrent(T stateful, org.statefulj.fsm.model.State<T> current) {
        T t = stateful;
        synchronized (t) {
            try {
                this.getStateField(stateful).set(stateful, current.getName());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrent(T stateful, org.statefulj.fsm.model.State<T> current, org.statefulj.fsm.model.State<T> next) throws StaleStateException {
        T t = stateful;
        synchronized (t) {
            if (!this.getCurrent(stateful).equals(current)) {
                throw new StaleStateException();
            }
            this.setCurrent(stateful, next);
        }
    }

    private Field getStateField(T stateful) {
        if (this.stateField == null) {
            this.stateField = this.locateStateField(stateful);
        }
        return this.stateField;
    }

    private synchronized Field locateStateField(T stateful) {
        Field field = null;
        if (this.stateFieldName != null && !this.stateFieldName.equals("")) {
            field = ReflectionUtils.getField(stateful.getClass(), (String)this.stateFieldName);
        } else {
            field = ReflectionUtils.getFirstAnnotatedField(stateful.getClass(), State.class);
            if (field != null) {
                this.stateFieldName = field.getName();
            }
        }
        if (field == null) {
            throw new RuntimeException("Unable to locate a State field for stateful: " + stateful);
        }
        field.setAccessible(true);
        return field;
    }
}

