/*
 * Decompiled with CFR 0.152.
 */
package org.statefulj.fsm;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.statefulj.fsm.Persister;
import org.statefulj.fsm.RetryException;
import org.statefulj.fsm.StaleStateException;
import org.statefulj.fsm.TooBusyException;
import org.statefulj.fsm.WaitAndRetryException;
import org.statefulj.fsm.model.Action;
import org.statefulj.fsm.model.State;
import org.statefulj.fsm.model.StateActionPair;
import org.statefulj.fsm.model.Transition;

public class FSM<T> {
    private static final Logger logger = LoggerFactory.getLogger(FSM.class);
    private static final int DEFAULT_RETRIES = 20;
    private static final int DEFAULT_RETRY_INTERVAL = 250;
    private int retryAttempts = 20;
    private int retryInterval = 250;
    private Persister<T> persister;
    private String name = "FSM";

    public FSM(String name) {
        this.name = name;
    }

    public FSM(Persister<T> persister) {
        this.persister = persister;
    }

    public FSM(String name, Persister<T> persister) {
        this.name = name;
        this.persister = persister;
    }

    public FSM(String name, Persister<T> persister, int retryAttempts, int retryInterval) {
        this.name = name;
        this.persister = persister;
        this.retryAttempts = retryAttempts;
        this.retryInterval = retryInterval;
    }

    public State<T> onEvent(T stateful, String event, Object ... args) throws TooBusyException {
        for (int attempts = 0; this.retryAttempts == -1 || attempts < this.retryAttempts; ++attempts) {
            try {
                State<T> current = this.getCurrentState(stateful);
                Transition<T> transition = current.getTransition(event);
                if (transition != null) {
                    current = this.transition(stateful, current, event, transition, args);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}({})::{}({})->{}/noop", new Object[]{this.name, stateful.getClass().getSimpleName(), current.getName(), event, current.getName()});
                    }
                    if (current.isBlocking()) {
                        this.setCurrent(stateful, current, current);
                        throw new WaitAndRetryException(this.retryInterval);
                    }
                }
                return current;
            }
            catch (RetryException re) {
                logger.warn("{}({})::Retrying event", (Object)this.name, stateful);
                if (!WaitAndRetryException.class.isInstance(re)) continue;
                try {
                    Thread.sleep(((WaitAndRetryException)re).getWait());
                    continue;
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
            }
        }
        logger.error("{}({})::Unable to process event", (Object)this.name, stateful);
        throw new TooBusyException();
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public void setRetryAttempts(int retries) {
        this.retryAttempts = retries;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public Persister<T> getPersister() {
        return this.persister;
    }

    public void setPersister(Persister<T> persister) {
        this.persister = persister;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public State<T> getCurrentState(T obj) {
        return this.persister.getCurrent(obj);
    }

    protected State<T> transition(T stateful, State<T> current, String event, Transition<T> transition, Object ... args) throws RetryException {
        StateActionPair<T> pair = transition.getStateActionPair(stateful);
        this.setCurrent(stateful, current, pair.getState());
        this.executeAction(pair.getAction(), stateful, event, current.getName(), pair.getState().getName(), args);
        return pair.getState();
    }

    protected void setCurrent(T stateful, State<T> current, State<T> next) throws StaleStateException {
        this.persister.setCurrent(stateful, current, next);
    }

    protected void executeAction(Action<T> action, T stateful, String event, String from, String to, Object ... args) throws RetryException {
        if (logger.isDebugEnabled()) {
            logger.debug("{}({})::{}({})->{}/{}", new Object[]{this.name, stateful.getClass().getSimpleName(), from, event, to, action == null ? "noop" : action.toString()});
        }
        if (action != null) {
            action.execute(stateful, event, args);
        }
    }
}

