/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import java.util.Collections;
import java.util.List;
import org.ssssssss.script.asm.Label;
import org.ssssssss.script.compile.MagicScriptCompiler;
import org.ssssssss.script.exception.MagicExitException;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.VarIndex;
import org.ssssssss.script.parsing.ast.Node;
import org.ssssssss.script.parsing.ast.statement.VariableDefine;

public class TryStatement
extends Node {
    private final VarIndex exceptionVarNode;
    private final List<Node> tryBlock;
    private final List<VariableDefine> tryResources;
    private final List<Node> catchBlock;
    private final List<Node> finallyBlock;

    public TryStatement(Span span, VarIndex exceptionVarNode, List<Node> tryBlock, final List<VariableDefine> tryResources, List<Node> catchBlock, List<Node> finallyBlock) {
        super(span);
        this.exceptionVarNode = exceptionVarNode;
        this.tryBlock = tryBlock;
        this.tryResources = tryResources;
        Collections.reverse(this.tryResources);
        this.catchBlock = catchBlock;
        this.finallyBlock = finallyBlock;
        this.finallyBlock.add(0, new Node(new Span("auto close")){

            @Override
            public void visitMethod(MagicScriptCompiler compiler) {
                tryResources.forEach(it -> it.visitMethod(compiler));
            }

            @Override
            public void compile(MagicScriptCompiler compiler) {
                tryResources.forEach(it -> compiler.load(it.getVarIndex()).invoke(184, TryStatement.class, "autoClose", Void.TYPE, Object.class));
            }
        });
    }

    @Override
    public void visitMethod(MagicScriptCompiler compiler) {
        this.tryBlock.forEach(it -> it.visitMethod(compiler));
        this.catchBlock.forEach(it -> it.visitMethod(compiler));
        this.finallyBlock.forEach(it -> it.visitMethod(compiler));
    }

    public static void autoClose(Object object) {
        if (object instanceof AutoCloseable) {
            try {
                ((AutoCloseable)object).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void compile(MagicScriptCompiler compiler) {
        boolean hasFinally;
        boolean hasCatch = this.exceptionVarNode != null;
        boolean bl = hasFinally = !this.finallyBlock.isEmpty();
        if (hasFinally) {
            this.compileWithFinally(compiler, hasCatch);
        } else {
            this.compileWithoutFinally(compiler, hasCatch);
        }
    }

    private void compileWithFinally(MagicScriptCompiler compiler, boolean hasCatch) {
        Label tryStart = new Label();
        Label tryEnd = new Label();
        Label catchMagicExitException = new Label();
        Label catchThrowable = new Label();
        Label catchEnd = new Label();
        Label finallyStart = new Label();
        Label finallyThrowStart = new Label();
        Label end = new Label();
        compiler.pushFinallyBlock(this.finallyBlock);
        compiler.label(tryStart).compile(this.tryResources).compile(this.tryBlock).label(tryEnd);
        compiler.popFinallyBlock();
        compiler.label(finallyStart).compile(this.finallyBlock).jump(167, end);
        compiler.label(catchMagicExitException).insn(191);
        if (hasCatch) {
            compiler.pushFinallyBlock(this.finallyBlock);
            compiler.label(catchThrowable).store(3).pre_store(this.exceptionVarNode).load3().store(this.exceptionVarNode).compile(this.catchBlock).label(catchEnd);
            compiler.popFinallyBlock();
            compiler.jump(167, finallyStart);
        }
        compiler.label(finallyThrowStart).store(3).compile(this.finallyBlock).load3().insn(191);
        compiler.label(end);
        compiler.tryCatch(tryStart, tryEnd, finallyThrowStart, MagicExitException.class);
        if (hasCatch) {
            compiler.tryCatch(tryStart, tryEnd, catchThrowable, Throwable.class);
            compiler.tryCatch(catchThrowable, catchEnd, finallyThrowStart, null);
        }
        compiler.tryCatch(tryStart, tryEnd, finallyThrowStart, null);
    }

    private void compileWithoutFinally(MagicScriptCompiler compiler, boolean hasCatch) {
        Label tryStart = new Label();
        Label tryEnd = new Label();
        Label catchMagicExitException = new Label();
        Label catchThrowable = new Label();
        compiler.label(tryStart).compile(this.tryResources).compile(this.tryBlock).label(tryEnd);
        compiler.label(catchMagicExitException).insn(191);
        if (hasCatch) {
            compiler.label(catchThrowable).store(3).pre_store(this.exceptionVarNode).load3().store(this.exceptionVarNode).compile(this.catchBlock);
        }
        compiler.tryCatch(tryStart, tryEnd, catchMagicExitException, MagicExitException.class);
        if (hasCatch) {
            compiler.tryCatch(tryStart, tryEnd, catchThrowable, Throwable.class);
        }
    }
}

