/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script;

import java.util.ArrayList;
import org.ssssssss.script.exception.MagicExitException;
import org.ssssssss.script.exception.MagicScriptException;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.TokenStream;
import org.ssssssss.script.runtime.MagicScriptRuntime;

public class MagicScriptError {
    public static void error(String message, TokenStream stream) {
        if (stream.hasMore()) {
            MagicScriptError.error(message, stream.consume().getSpan());
        } else {
            MagicScriptError.error(message, stream.getPrev().getSpan());
        }
    }

    public static void error(String message, Span location, Throwable cause) {
        if ((cause = MagicScriptError.unwrap(cause)) instanceof MagicExitException) {
            throw (MagicExitException)cause;
        }
        if (cause instanceof MagicScriptException) {
            MagicScriptException mse = (MagicScriptException)cause;
            if (mse.getLocation() == null) {
                MagicScriptError.error(message, location, cause.getCause());
                return;
            }
            throw mse;
        }
        String errorMessage = message;
        if (location != null) {
            Span.Line line = location.getLine();
            errorMessage = errorMessage + " at Row:";
            errorMessage = errorMessage + line.getLineNumber() + "~" + line.getEndLineNumber() + ",Col:";
            errorMessage = errorMessage + line.getStartCol() + "~" + line.getEndCol() + "\n\n";
            errorMessage = errorMessage + line.getText();
            errorMessage = errorMessage + "\n";
            int errorStart = location.getStart() - line.getStart();
            int errorEnd = errorStart + location.getText().length() - 1;
            int n = line.getText().length();
            for (int i = 0; i < n; ++i) {
                boolean useTab = line.getText().charAt(i) == '\t';
                errorMessage = errorMessage + (i >= errorStart && i <= errorEnd ? "^" : (useTab ? "\t" : " "));
            }
        }
        if (cause == null) {
            throw new MagicScriptException(errorMessage, message, location);
        }
        throw new MagicScriptException(errorMessage, message, cause, location);
    }

    public static void error(String message, Span location) {
        MagicScriptError.error(message, location, null);
    }

    public static Throwable unwrap(Throwable root) {
        for (Throwable parent = root; parent != null; parent = parent.getCause()) {
            if (!(parent instanceof MagicScriptException)) continue;
            root = parent;
        }
        return root;
    }

    public static void transfer(MagicScriptRuntime runtime, Throwable t) {
        StackTraceElement[] elements = t.getStackTrace();
        Throwable cause = t;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        Span span = null;
        if (runtime != null) {
            ArrayList<StackTraceElement> elementList = new ArrayList<StackTraceElement>();
            String className = runtime.getClass().getName();
            for (StackTraceElement element : elements) {
                if (element.getLineNumber() > -1 && element.getClassName().equals(className)) {
                    Span currentSpan = runtime.getSpan(element.getLineNumber());
                    elementList.add(new StackTraceElement(element.getClassName(), element.getMethodName(), element.getFileName(), currentSpan.getLine().getLineNumber()));
                    if (span != null) continue;
                    span = currentSpan;
                    continue;
                }
                elementList.add(element);
            }
            cause.setStackTrace(elementList.toArray(new StackTraceElement[0]));
        }
        MagicScriptError.error(t.getMessage(), span, cause);
    }
}

