/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast;

import java.util.function.Supplier;
import org.ssssssss.script.MagicScriptError;
import org.ssssssss.script.compile.MagicScriptCompileException;
import org.ssssssss.script.compile.MagicScriptCompiler;
import org.ssssssss.script.parsing.Token;
import org.ssssssss.script.parsing.TokenType;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.VariableSetter;
import org.ssssssss.script.parsing.ast.statement.VariableAccess;
import org.ssssssss.script.runtime.handle.BitHandle;
import org.ssssssss.script.runtime.handle.OperatorHandle;

public class UnaryOperation
extends Expression {
    private final UnaryOperator operator;
    private final Expression operand;
    private final boolean atAfter;

    public UnaryOperation(Token operator, Expression operand) {
        this(operator, operand, false);
    }

    public UnaryOperation(Token operator, Expression operand, boolean atAfter) {
        super(operator.getSpan());
        if (operator.getType().isModifiable() && operand instanceof VariableAccess && ((VariableAccess)operand).getVarIndex().isReadonly()) {
            MagicScriptError.error("const\u4fee\u9970\u7684\u53d8\u91cf\u4e0d\u80fd\u88ab\u4fee\u6539", this.getSpan());
        }
        this.operator = UnaryOperator.getOperator(operator);
        this.operand = operand;
        this.atAfter = atAfter;
    }

    public UnaryOperator getOperator() {
        return this.operator;
    }

    @Override
    public void visitMethod(MagicScriptCompiler compiler) {
        this.operand.visitMethod(compiler);
    }

    @Override
    public void compile(MagicScriptCompiler compiler) {
        switch (this.getOperator()) {
            case Not: {
                compiler.compile(this.operand).invoke(184, OperatorHandle.class, "isFalse", Boolean.TYPE, Object.class).asBoolean();
                break;
            }
            case BitNot: {
                compiler.compile(this.operand).invoke(184, BitHandle.class, "not", Object.class, Object.class);
                break;
            }
            case PlusPlus: 
            case MinusMinus: {
                if (this.operand instanceof VariableSetter) {
                    boolean access = this.operand instanceof VariableAccess;
                    Supplier<MagicScriptCompiler> plus = () -> compiler.visit(this.operand).visitInt(this.operator == UnaryOperator.PlusPlus ? 1 : -1).asInteger().arithmetic("plus");
                    if (this.atAfter) {
                        if (access) {
                            compiler.compile(this.operand).pre_store(((VariableAccess)this.operand).getVarIndex());
                            plus.get().store(((VariableAccess)this.operand).getVarIndex());
                            break;
                        }
                        compiler.compile(this.operand);
                        compiler.newRuntimeContext();
                        ((VariableSetter)((Object)this.operand)).compile_visit_variable(compiler);
                        plus.get().call("set_variable_value", 4).insn(87);
                        break;
                    }
                    if (access) {
                        compiler.pre_store(((VariableAccess)this.operand).getVarIndex());
                        plus.get().store(((VariableAccess)this.operand).getVarIndex()).visit(this.operand);
                        break;
                    }
                    compiler.newRuntimeContext();
                    ((VariableSetter)((Object)this.operand)).compile_visit_variable(compiler);
                    plus.get().call("set_variable_value", 4);
                    break;
                }
                throw new MagicScriptCompileException("\u6b64\u5904\u4e0d\u652f\u6301++/--\u64cd\u4f5c");
            }
            case Negate: {
                compiler.visit(this.operand).visitInt(-1).asInteger().arithmetic("mul");
                break;
            }
        }
    }

    public static enum UnaryOperator {
        Not,
        Negate,
        Positive,
        PlusPlus,
        MinusMinus,
        BitNot;


        public static UnaryOperator getOperator(Token op) {
            if (op.getType() == TokenType.Not) {
                return Not;
            }
            if (op.getType() == TokenType.Plus) {
                return Positive;
            }
            if (op.getType() == TokenType.Minus) {
                return Negate;
            }
            if (op.getType() == TokenType.PlusPlus) {
                return PlusPlus;
            }
            if (op.getType() == TokenType.MinusMinus) {
                return MinusMinus;
            }
            if (op.getType() == TokenType.BitNot) {
                return BitNot;
            }
            MagicScriptError.error("\u4e0d\u652f\u6301\u7684\u4e00\u5143\u64cd\u4f5c\u7b26\uff1a" + op, op.getSpan());
            return null;
        }
    }
}

