/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(JsonUtils.class);

    public static String toJsonString(Object target) {
        try {
            return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(target);
        }
        catch (JsonProcessingException e) {
            logger.error("json\u5e8f\u5217\u5316\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static String toJsonStringWithoutPretty(Object target) {
        try {
            return MAPPER.writeValueAsString(target);
        }
        catch (JsonProcessingException e) {
            logger.error("json\u5e8f\u5217\u5316\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static String toJsonStringWithoutLog(Object target) {
        try {
            return MAPPER.writeValueAsString(target);
        }
        catch (Exception e) {
            return target == null ? null : target.toString();
        }
    }

    public static <T> T readValue(String json, TypeReference<T> typeReference) {
        try {
            return (T)MAPPER.readValue(json, typeReference);
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6json\u5931\u8d25,json:{}", (Object)json, (Object)e);
            return null;
        }
    }

    public static <T> T readValue(String json, Class<T> clazz) {
        try {
            return (T)MAPPER.readValue(json, clazz);
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6json\u5931\u8d25,json:{}", (Object)json, (Object)e);
            return null;
        }
    }

    public static <T> T readValue(byte[] bytes, Class<T> clazz) {
        try {
            return (T)MAPPER.readValue(bytes, clazz);
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6json\u5931\u8d25,json:{}", (Object)new String(bytes), (Object)e);
            return null;
        }
    }

    public static <T> T readValue(byte[] bytes, JavaType javaType) {
        try {
            return (T)MAPPER.readValue(bytes, javaType);
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6json\u5931\u8d25,json:{}", (Object)new String(bytes), (Object)e);
            return null;
        }
    }

    public static byte[] toJsonBytes(Object target) {
        String json = JsonUtils.toJsonString(target);
        return json == null ? new byte[]{} : json.getBytes(StandardCharsets.UTF_8);
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Logger.class, (JsonSerializer)new JsonSerializer<Logger>(){

            public void serialize(Logger value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeString(value.toString());
            }
        });
        MAPPER.registerModule((Module)simpleModule);
    }
}

