/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules.db.mybatis;

import java.io.ByteArrayInputStream;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ssssssss.magicapi.core.exception.MagicAPIException;
import org.ssssssss.magicapi.modules.db.mybatis.ForeachSqlNode;
import org.ssssssss.magicapi.modules.db.mybatis.IfSqlNode;
import org.ssssssss.magicapi.modules.db.mybatis.NodeStream;
import org.ssssssss.magicapi.modules.db.mybatis.SetSqlNode;
import org.ssssssss.magicapi.modules.db.mybatis.SqlNode;
import org.ssssssss.magicapi.modules.db.mybatis.TextSqlNode;
import org.ssssssss.magicapi.modules.db.mybatis.TrimSqlNode;
import org.ssssssss.magicapi.modules.db.mybatis.WhereSqlNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MybatisParser {
    private static final Pattern ESCAPE_LT_PATTERN = Pattern.compile("<([\\d'\"\\s=>#$?(])");
    private static final String ESCAPE_LT_REPLACEMENT = "&lt;$1";

    public static SqlNode parse(String xml) {
        try {
            xml = "<magic-api>" + MybatisParser.escapeXml(xml) + "</magic-api>";
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(xml.getBytes()));
            TextSqlNode sqlNode = new TextSqlNode("");
            MybatisParser.parseNodeList(sqlNode, new NodeStream(document.getDocumentElement().getChildNodes()));
            return sqlNode;
        }
        catch (Exception e) {
            throw new MagicAPIException("SQL\u89e3\u6790\u9519\u8bef", e);
        }
    }

    private static String escapeXml(String xml) {
        return ESCAPE_LT_PATTERN.matcher(xml).replaceAll(ESCAPE_LT_REPLACEMENT);
    }

    private static void parseNodeList(SqlNode sqlNode, NodeStream stream) {
        while (stream.hasMore()) {
            SqlNode childNode;
            if (stream.match((short)3)) {
                childNode = new TextSqlNode(stream.consume().getNodeValue().trim());
            } else if (stream.match("foreach")) {
                childNode = MybatisParser.parseForeachSqlNode(stream);
            } else if (stream.match("if")) {
                childNode = MybatisParser.parseIfSqlNode(stream);
            } else if (stream.match("trim")) {
                childNode = MybatisParser.parseTrimSqlNode(stream);
            } else if (stream.match("set")) {
                childNode = MybatisParser.parseSetSqlNode(stream);
            } else if (stream.match("where")) {
                childNode = MybatisParser.parseWhereSqlNode(stream);
            } else {
                throw new UnsupportedOperationException("Unsupported tags :" + stream.consume().getNodeName());
            }
            sqlNode.addChildNode(childNode);
        }
    }

    private static IfSqlNode parseIfSqlNode(NodeStream stream) {
        Node ifNode = stream.consume();
        String test = MybatisParser.getNodeAttributeValue(ifNode, "test");
        SqlNode nextNode = null;
        if (stream.match("else")) {
            nextNode = new TextSqlNode("");
            MybatisParser.parseNodeList(nextNode, new NodeStream(stream.consume().getChildNodes()));
        } else if (stream.match("elseif")) {
            nextNode = MybatisParser.parseIfSqlNode(stream);
        }
        return MybatisParser.processChildren(new IfSqlNode(test, nextNode), ifNode);
    }

    private static <T extends SqlNode> T processChildren(T sqlNode, Node node) {
        if (node.hasChildNodes()) {
            MybatisParser.parseNodeList(sqlNode, new NodeStream(node.getChildNodes()));
        }
        return sqlNode;
    }

    private static ForeachSqlNode parseForeachSqlNode(NodeStream stream) {
        Node node = stream.consume();
        ForeachSqlNode foreachSqlNode = new ForeachSqlNode();
        foreachSqlNode.setCollection(MybatisParser.getNodeAttributeValue(node, "collection"));
        foreachSqlNode.setSeparator(MybatisParser.getNodeAttributeValue(node, "separator", ","));
        foreachSqlNode.setClose(MybatisParser.getNodeAttributeValue(node, "close", ")"));
        foreachSqlNode.setOpen(MybatisParser.getNodeAttributeValue(node, "open", "("));
        foreachSqlNode.setItem(MybatisParser.getNodeAttributeValue(node, "item"));
        foreachSqlNode.setIndex(MybatisParser.getNodeAttributeValue(node, "index"));
        return MybatisParser.processChildren(foreachSqlNode, node);
    }

    private static TrimSqlNode parseTrimSqlNode(NodeStream stream) {
        Node node = stream.consume();
        TrimSqlNode trimSqlNode = new TrimSqlNode();
        trimSqlNode.setPrefix(MybatisParser.getNodeAttributeValue(node, "prefix"));
        trimSqlNode.setPrefixOverrides(MybatisParser.getNodeAttributeValue(node, "prefixOverrides"));
        trimSqlNode.setSuffix(MybatisParser.getNodeAttributeValue(node, "suffix"));
        trimSqlNode.setSuffixOverrides(MybatisParser.getNodeAttributeValue(node, "suffixOverrides"));
        return MybatisParser.processChildren(trimSqlNode, node);
    }

    private static SetSqlNode parseSetSqlNode(NodeStream stream) {
        return MybatisParser.processChildren(new SetSqlNode(), stream.consume());
    }

    private static WhereSqlNode parseWhereSqlNode(NodeStream stream) {
        return MybatisParser.processChildren(new WhereSqlNode(), stream.consume());
    }

    private static String getNodeAttributeValue(Node node, String attributeKey, String defaultValue) {
        Node item = node.getAttributes().getNamedItem(attributeKey);
        return item != null ? item.getNodeValue() : defaultValue;
    }

    private static String getNodeAttributeValue(Node node, String attributeKey) {
        return MybatisParser.getNodeAttributeValue(node, attributeKey, null);
    }
}

