/*
 * Decompiled with CFR 0.152.
 */
package org.srcdeps.mvn.enforcer;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.ProjectExecutionEvent;
import org.apache.maven.execution.ProjectExecutionListener;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.srcdeps.core.SrcVersion;
import org.srcdeps.core.config.Maven;
import org.srcdeps.core.config.MavenAssertions;
import org.srcdeps.mvn.config.ConfigurationProducer;

@Named
@Singleton
public class SrcdepsEnforcer
implements ProjectExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(SrcdepsEnforcer.class);
    private final ConfigurationProducer configurationProducer;

    static String[] assertFailWith(MavenAssertions failWith, List<String> goals, List<String> profiles, Properties properties) {
        log.debug("srcdeps: The enforcer is using failWith [{}]", (Object)failWith);
        Set failWithGoals = failWith.getGoals();
        for (String goal : goals) {
            if (!failWithGoals.contains(goal)) continue;
            return new String[]{"goal", goal};
        }
        Set failWithProfiles = failWith.getProfiles();
        for (String profile : profiles) {
            if (!failWithProfiles.contains(profile)) continue;
            return new String[]{"profile", profile};
        }
        Set failWithProperties = failWith.getProperties();
        for (String keyVal : failWithProperties) {
            String key;
            int eqPos = keyVal.indexOf(61);
            if (eqPos >= 0) {
                key = keyVal.substring(0, eqPos);
                String val = keyVal.substring(eqPos + 1);
                if (!val.equals(properties.get(key))) continue;
                return new String[]{"property", keyVal};
            }
            key = keyVal;
            if (!properties.containsKey(key)) continue;
            return new String[]{"property", keyVal};
        }
        return null;
    }

    static String[] assertFailWithout(MavenAssertions failWithout, List<String> goals, List<String> profiles, Properties properties) {
        log.debug("srcdeps: The enforcer is using failWithout [{}]", (Object)failWithout);
        LinkedHashSet failWithoutGoals = new LinkedHashSet(failWithout.getGoals());
        failWithoutGoals.removeAll(goals);
        if (!failWithoutGoals.isEmpty()) {
            return new String[]{"goals missing", ((Object)failWithoutGoals).toString()};
        }
        LinkedHashSet failWithoutProfiles = new LinkedHashSet(failWithout.getProfiles());
        failWithoutProfiles.removeAll(profiles);
        if (!failWithoutProfiles.isEmpty()) {
            return new String[]{"profiles missing", ((Object)failWithoutProfiles).toString()};
        }
        LinkedHashSet failWithoutProperties = new LinkedHashSet(failWithout.getProperties());
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            String key = prop.getKey().toString();
            failWithoutProperties.remove(key);
            Object val = prop.getValue();
            if (val == null) continue;
            failWithoutProperties.remove(String.valueOf(key) + "=" + val.toString());
        }
        if (!failWithoutProperties.isEmpty()) {
            return new String[]{"properties missing", ((Object)failWithoutProperties).toString()};
        }
        return null;
    }

    private static void assertNotSrcdeps(List<Dependency> deps, String[] violation) throws LifecycleExecutionException {
        for (Dependency dep : deps) {
            SrcdepsEnforcer.assertNotSrcdeps(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), violation);
        }
    }

    private static void assertNotSrcdeps(String group, String artifact, String version, String[] violation) throws LifecycleExecutionException {
        if (SrcVersion.isSrcVersion((String)version)) {
            throw new LifecycleExecutionException(String.format("This build was configured to fail if there is a source dependency [%s:%s:%s] and %s [%s]", group, artifact, version, violation[0], violation[1]));
        }
    }

    @Inject
    public SrcdepsEnforcer(ConfigurationProducer configurationProducer) {
        this.configurationProducer = configurationProducer;
    }

    public void afterProjectExecutionFailure(ProjectExecutionEvent event) {
    }

    public void afterProjectExecutionSuccess(ProjectExecutionEvent event) throws LifecycleExecutionException {
    }

    public void beforeProjectExecution(ProjectExecutionEvent event) throws LifecycleExecutionException {
    }

    public void beforeProjectLifecycleExecution(ProjectExecutionEvent event) throws LifecycleExecutionException {
        MavenProject project = event.getProject();
        log.info("srcdeps: The enforcer checks for violations in [{}:{}]", (Object)project.getGroupId(), (Object)project.getArtifactId());
        Maven maven = this.configurationProducer.getConfiguration().getMaven();
        List mojoExecutions = event.getExecutionPlan();
        ArrayList<String> goals = new ArrayList<String>(mojoExecutions.size());
        for (MojoExecution mojoExecution : mojoExecutions) {
            MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
            goals.add(mojoDescriptor.getFullGoalName());
            goals.add(mojoDescriptor.getGoal());
        }
        ArrayList<String> profiles = new ArrayList<String>();
        List activeProfiles = project.getActiveProfiles();
        for (Profile profile : activeProfiles) {
            String id = profile.getId();
            profiles.add(id);
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)project.getProperties());
        props.putAll((Map<?, ?>)System.getProperties());
        String[] firstViolation = SrcdepsEnforcer.assertFailWithout(maven.getFailWithout(), goals, profiles, props);
        if (firstViolation == null) {
            firstViolation = SrcdepsEnforcer.assertFailWith(maven.getFailWith(), goals, profiles, props);
        }
        if (firstViolation != null) {
            List deps;
            DependencyManagement dm;
            Artifact parent = project.getParentArtifact();
            if (parent != null) {
                SrcdepsEnforcer.assertNotSrcdeps(parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), firstViolation);
            }
            if ((dm = project.getDependencyManagement()) != null && (deps = dm.getDependencies()) != null) {
                SrcdepsEnforcer.assertNotSrcdeps(deps, firstViolation);
            }
            if ((deps = project.getDependencies()) != null) {
                SrcdepsEnforcer.assertNotSrcdeps(deps, firstViolation);
            }
        }
    }
}

