/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.support;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class KeyStoreFactoryBean
implements FactoryBean<KeyStore>,
InitializingBean {
    private static final Log logger = LogFactory.getLog(KeyStoreFactoryBean.class);
    private @Nullable KeyStore keyStore;
    private @Nullable String type;
    private @Nullable String provider;
    private @Nullable Resource location;
    private char @Nullable [] password;

    public void setLocation(@Nullable Resource location) {
        this.location = location;
    }

    public void setPassword(@Nullable String password) {
        if (password != null) {
            this.password = password.toCharArray();
        }
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setType(@Nullable String type) {
        this.type = type;
    }

    public KeyStore getObject() {
        Assert.state((this.keyStore != null ? 1 : 0) != 0, (String)"KeyStore has not been initialized");
        return this.keyStore;
    }

    public Class<KeyStore> getObjectType() {
        return KeyStore.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public final void afterPropertiesSet() throws GeneralSecurityException, IOException {
        this.keyStore = StringUtils.hasLength((String)this.provider) && StringUtils.hasLength((String)this.type) ? KeyStore.getInstance(this.type, this.provider) : (StringUtils.hasLength((String)this.type) ? KeyStore.getInstance(this.type) : KeyStore.getInstance(KeyStore.getDefaultType()));
        try (InputStream is = null;){
            if (this.location != null && this.location.exists()) {
                is = this.location.getInputStream();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Loading key store from " + String.valueOf(this.location)));
                }
            } else if (logger.isWarnEnabled()) {
                logger.warn((Object)"Creating empty key store");
            }
            this.keyStore.load(is, this.password);
        }
    }
}

