/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.wss4j2.support;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.Merlin;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class CryptoFactoryBean
implements FactoryBean<Crypto>,
InitializingBean {
    private Properties configuration = new Properties();
    private Crypto crypto;
    private static final String CRYPTO_PROVIDER_PROPERTY = "org.apache.wss4j.crypto.provider";
    private static final String CRYPTO_MERLIN_FILE_PROPERTY = "org.apache.ws.security.crypto.merlin.file";

    public void setConfiguration(Properties properties) {
        Assert.notNull((Object)properties, (String)"'properties' must not be null");
        this.configuration.putAll((Map<?, ?>)properties);
    }

    public void setCryptoProvider(Class<? extends Crypto> cryptoProviderClass) {
        this.configuration.setProperty(CRYPTO_PROVIDER_PROPERTY, cryptoProviderClass.getName());
    }

    public void setKeyStoreLocation(Resource location) throws IOException {
        String resourcePath = this.getResourcePath(location);
        this.configuration.setProperty(CRYPTO_MERLIN_FILE_PROPERTY, resourcePath);
    }

    private String getResourcePath(Resource resource) throws IOException {
        try {
            return resource.getFile().getAbsolutePath();
        }
        catch (IOException ex) {
            if (resource instanceof ClassPathResource) {
                ClassPathResource classPathResource = (ClassPathResource)resource;
                return classPathResource.getPath();
            }
            throw ex;
        }
    }

    public void setKeyStoreProvider(String provider) {
        this.configuration.setProperty("org.apache.ws.security.crypto.merlin.keystore.provider", provider);
    }

    public void setKeyStorePassword(String password) {
        this.configuration.setProperty("org.apache.ws.security.crypto.merlin.keystore.password", password);
    }

    public void setKeyStoreType(String type) {
        this.configuration.setProperty("org.apache.ws.security.crypto.merlin.keystore.type", type);
    }

    public void setTrustStorePassword(String password) {
        this.configuration.setProperty("org.apache.ws.security.crypto.merlin.cacerts.password", password);
    }

    public void setDefaultX509Alias(String defaultX509Alias) {
        this.configuration.setProperty("org.apache.ws.security.crypto.merlin.keystore.alias", defaultX509Alias);
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.configuration.containsKey(CRYPTO_PROVIDER_PROPERTY)) {
            this.configuration.setProperty(CRYPTO_PROVIDER_PROPERTY, Merlin.class.getName());
        }
        this.crypto = CryptoFactory.getInstance((Properties)this.configuration);
    }

    public Class<Crypto> getObjectType() {
        return Crypto.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public Crypto getObject() throws Exception {
        return this.crypto;
    }
}

