/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.xwss.callback;

import com.sun.xml.wss.impl.callback.PasswordCallback;
import com.sun.xml.wss.impl.callback.UsernameCallback;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.ws.soap.security.callback.AbstractCallbackHandler;

public class SimpleUsernamePasswordCallbackHandler
extends AbstractCallbackHandler
implements InitializingBean {
    private String username;
    private String password;

    public SimpleUsernamePasswordCallbackHandler() {
    }

    public SimpleUsernamePasswordCallbackHandler(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.username, (String)"username must be set");
        Assert.hasLength((String)this.password, (String)"password must be set");
    }

    @Override
    protected void handleInternal(Callback callback) throws IOException, UnsupportedCallbackException {
        if (callback instanceof UsernameCallback) {
            UsernameCallback usernameCallback = (UsernameCallback)callback;
            usernameCallback.setUsername(this.username);
        } else if (callback instanceof PasswordCallback) {
            PasswordCallback passwordCallback = (PasswordCallback)callback;
            passwordCallback.setPassword(this.password);
        } else {
            throw new UnsupportedCallbackException(callback);
        }
    }
}

