/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.conversation.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.conversation.Conversation;
import org.springframework.webflow.conversation.ConversationId;
import org.springframework.webflow.conversation.impl.ConversationContainer;
import org.springframework.webflow.conversation.impl.ConversationLock;
import org.springframework.webflow.conversation.impl.SessionBindingConversationManager;
import org.springframework.webflow.core.collection.SharedAttributeMap;

public class ContainedConversation
implements Conversation,
Serializable {
    private static final Log logger = LogFactory.getLog(SessionBindingConversationManager.class);
    private ConversationContainer container;
    private ConversationId id;
    private ConversationLock lock;
    private Map<Object, Object> attributes;

    public ContainedConversation(ConversationContainer container, ConversationId id, ConversationLock lock) {
        this.container = container;
        this.id = id;
        this.lock = lock;
        this.attributes = new HashMap<Object, Object>();
    }

    protected void setContainer(ConversationContainer container) {
        this.container = container;
    }

    @Override
    public ConversationId getId() {
        return this.id;
    }

    protected void setId(ConversationId id) {
        this.id = id;
    }

    @Override
    public void lock() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Locking conversation " + this.id));
        }
        this.lock.lock();
    }

    @Override
    public Object getAttribute(Object name) {
        return this.attributes.get(name);
    }

    @Override
    public void putAttribute(Object name, Object value) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Putting conversation attribute '" + name + "' with value " + value));
        }
        this.attributes.put(name, value);
    }

    @Override
    public void removeAttribute(Object name) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing conversation attribute '" + name + "'"));
        }
        this.attributes.remove(name);
    }

    @Override
    public void end() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Ending conversation " + this.id));
        }
        this.container.removeConversation(this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unlocking conversation " + this.id));
        }
        this.lock.unlock();
        SharedAttributeMap<Object> sessionMap = ExternalContextHolder.getExternalContext().getSessionMap();
        Object object = sessionMap.getMutex();
        synchronized (object) {
            sessionMap.put(this.container.getSessionKey(), this.container);
        }
    }

    public String toString() {
        return this.getId().toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ContainedConversation)) {
            return false;
        }
        return this.id.equals(((ContainedConversation)obj).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

