/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.security;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.access.vote.UnanimousBased;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.execution.EnterStateVetoException;
import org.springframework.webflow.execution.FlowExecutionListenerAdapter;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.security.SecurityRule;

public class SecurityFlowExecutionListener
extends FlowExecutionListenerAdapter {
    private AccessDecisionManager accessDecisionManager;

    public AccessDecisionManager getAccessDecisionManager() {
        return this.accessDecisionManager;
    }

    public void setAccessDecisionManager(AccessDecisionManager accessDecisionManager) {
        this.accessDecisionManager = accessDecisionManager;
    }

    @Override
    public void sessionCreating(RequestContext context, FlowDefinition definition) {
        SecurityRule rule = (SecurityRule)definition.getAttributes().get("secured");
        if (rule != null) {
            this.decide(rule, definition);
        }
    }

    @Override
    public void stateEntering(RequestContext context, StateDefinition state) throws EnterStateVetoException {
        SecurityRule rule = (SecurityRule)state.getAttributes().get("secured");
        if (rule != null) {
            this.decide(rule, state);
        }
    }

    @Override
    public void transitionExecuting(RequestContext context, TransitionDefinition transition) {
        SecurityRule rule = (SecurityRule)transition.getAttributes().get("secured");
        if (rule != null) {
            this.decide(rule, transition);
        }
    }

    protected void decide(SecurityRule rule, Object object) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Collection<ConfigAttribute> configAttributes = this.getConfigAttributes(rule);
        if (this.accessDecisionManager != null) {
            this.accessDecisionManager.decide(authentication, object, configAttributes);
        } else {
            AffirmativeBased abstractAccessDecisionManager;
            ArrayList<RoleVoter> voters = new ArrayList<RoleVoter>();
            voters.add(new RoleVoter());
            if (rule.getComparisonType() == 1) {
                abstractAccessDecisionManager = new AffirmativeBased();
            } else if (rule.getComparisonType() == 2) {
                abstractAccessDecisionManager = new UnanimousBased();
            } else {
                throw new IllegalStateException("Unknown SecurityRule match type: " + rule.getComparisonType());
            }
            abstractAccessDecisionManager.setDecisionVoters(voters);
            abstractAccessDecisionManager.decide(authentication, object, configAttributes);
        }
    }

    protected Collection<ConfigAttribute> getConfigAttributes(SecurityRule rule) {
        ArrayList<ConfigAttribute> configAttributes = new ArrayList<ConfigAttribute>();
        for (String attribute : rule.getAttributes()) {
            configAttributes.add((ConfigAttribute)new SecurityConfig(attribute));
        }
        return configAttributes;
    }
}

