/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.persistence;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.hibernate.FlushMode;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.FlowExecutionListenerAdapter;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;

public class HibernateFlowExecutionListener
extends FlowExecutionListenerAdapter {
    private static final boolean hibernate3Present = ClassUtils.isPresent((String)"org.hibernate.connection.ConnectionProvider", (ClassLoader)HibernateFlowExecutionListener.class.getClassLoader());
    private static final Method openSessionMethod = ReflectionUtils.findMethod(SessionFactory.class, (String)"openSession");
    private static final Method openSessionWithInterceptorMethod = ReflectionUtils.findMethod(SessionFactory.class, (String)"openSession", (Class[])new Class[]{Interceptor.class});
    public static final String PERSISTENCE_CONTEXT_ATTRIBUTE = "persistenceContext";
    private SessionFactory sessionFactory;
    private TransactionTemplate transactionTemplate;
    private Interceptor entityInterceptor;

    public HibernateFlowExecutionListener(SessionFactory sessionFactory, PlatformTransactionManager transactionManager) {
        this.sessionFactory = sessionFactory;
        this.transactionTemplate = new TransactionTemplate(transactionManager);
    }

    public void setEntityInterceptor(Interceptor entityInterceptor) {
        this.entityInterceptor = entityInterceptor;
    }

    @Override
    public void sessionStarting(RequestContext context, FlowSession session, MutableAttributeMap<?> input) {
        boolean reusePersistenceContext = false;
        if (this.isParentPersistenceContext(session)) {
            if (this.isPersistenceContext(session.getDefinition())) {
                this.setHibernateSession(session, this.getHibernateSession(session.getParent()));
                reusePersistenceContext = true;
            } else {
                this.unbind(this.getHibernateSession(session.getParent()));
            }
        }
        if (this.isPersistenceContext(session.getDefinition()) && !reusePersistenceContext) {
            Session hibernateSession = this.createSession(context);
            this.setHibernateSession(session, hibernateSession);
            this.bind(hibernateSession);
        }
    }

    @Override
    public void paused(RequestContext context) {
        if (this.isPersistenceContext(context.getActiveFlow())) {
            Session session = this.getHibernateSession(context.getFlowExecutionContext().getActiveSession());
            this.unbind(session);
            session.disconnect();
        }
    }

    @Override
    public void resuming(RequestContext context) {
        if (this.isPersistenceContext(context.getActiveFlow())) {
            this.bind(this.getHibernateSession(context.getFlowExecutionContext().getActiveSession()));
        }
    }

    @Override
    public void sessionEnding(RequestContext context, FlowSession session, String outcome, MutableAttributeMap<?> output) {
        if (this.isParentPersistenceContext(session)) {
            return;
        }
        if (this.isPersistenceContext(session.getDefinition())) {
            Session hibernateSession = this.getHibernateSession(session);
            Boolean commitStatus = session.getState().getAttributes().getBoolean("commit");
            if (Boolean.TRUE.equals(commitStatus)) {
                this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        HibernateFlowExecutionListener.this.sessionFactory.getCurrentSession();
                    }
                });
            }
            this.unbind(hibernateSession);
            hibernateSession.close();
        }
    }

    @Override
    public void sessionEnded(RequestContext context, FlowSession session, String outcome, AttributeMap<?> output) {
        if (this.isParentPersistenceContext(session) && !this.isPersistenceContext(session.getDefinition())) {
            this.bind(this.getHibernateSession(session.getParent()));
        }
    }

    @Override
    public void exceptionThrown(RequestContext context, FlowExecutionException exception) {
        if (context.getFlowExecutionContext().isActive() && this.isPersistenceContext(context.getActiveFlow())) {
            this.unbind(this.getHibernateSession(context.getFlowExecutionContext().getActiveSession()));
        }
    }

    private boolean isPersistenceContext(FlowDefinition flow) {
        return flow.getAttributes().contains(PERSISTENCE_CONTEXT_ATTRIBUTE);
    }

    private boolean isParentPersistenceContext(FlowSession flowSession) {
        return !flowSession.isRoot() && this.isPersistenceContext(flowSession.getParent().getDefinition());
    }

    private Session createSession(RequestContext context) {
        Session session;
        if (this.entityInterceptor != null) {
            if (hibernate3Present) {
                try {
                    session = (Session)openSessionWithInterceptorMethod.invoke((Object)this.sessionFactory, this.entityInterceptor);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Unable to open Hibernate 3 session", ex);
                }
                catch (InvocationTargetException ex) {
                    throw new IllegalStateException("Unable to open Hibernate 3 session", ex);
                }
            } else {
                session = this.sessionFactory.withOptions().interceptor(this.entityInterceptor).openSession();
            }
        } else if (hibernate3Present) {
            try {
                session = (Session)openSessionMethod.invoke((Object)this.sessionFactory, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Unable to open Hibernate 3 session", ex);
            }
            catch (InvocationTargetException ex) {
                throw new IllegalStateException("Unable to open Hibernate 3 session", ex);
            }
        } else {
            session = this.sessionFactory.openSession();
        }
        session.setFlushMode(FlushMode.MANUAL);
        return session;
    }

    private Session getHibernateSession(FlowSession session) {
        return (Session)session.getScope().get(PERSISTENCE_CONTEXT_ATTRIBUTE);
    }

    private void setHibernateSession(FlowSession session, Session hibernateSession) {
        session.getScope().put(PERSISTENCE_CONTEXT_ATTRIBUTE, hibernateSession);
    }

    private void bind(Session session) {
        SessionHolder sessionHolder = hibernate3Present ? new SessionHolder(session) : new org.springframework.orm.hibernate4.SessionHolder(session);
        TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)sessionHolder);
    }

    private void unbind(Session session) {
        if (TransactionSynchronizationManager.hasResource((Object)this.sessionFactory)) {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
        }
    }
}

