/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.conversation.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.JdkVersion;
import org.springframework.webflow.conversation.impl.ConversationLock;
import org.springframework.webflow.conversation.impl.JdkBackportConcurrentConversationLock;
import org.springframework.webflow.conversation.impl.JdkConcurrentConversationLock;
import org.springframework.webflow.conversation.impl.NoOpConversationLock;

class ConversationLockFactory {
    private static final Log logger = LogFactory.getLog(ConversationLockFactory.class);
    private static boolean backportConcurrentPresent;
    private int timeoutSeconds = 30;

    static {
        try {
            Class.forName("edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock");
            backportConcurrentPresent = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            backportConcurrentPresent = false;
        }
    }

    ConversationLockFactory() {
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public ConversationLock createLock() {
        if (JdkVersion.getMajorJavaVersion() >= 2) {
            return new JdkConcurrentConversationLock(this.timeoutSeconds);
        }
        if (backportConcurrentPresent) {
            return new JdkBackportConcurrentConversationLock(this.timeoutSeconds);
        }
        logger.warn((Object)"Unable to enable conversation locking. Switch to Java 5 or above, or put the 'backport-util-concurrent' package on the classpath to enable locking in your Java 1.4 environment.");
        return NoOpConversationLock.INSTANCE;
    }
}

