/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model.builder;

import org.springframework.core.io.Resource;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.engine.model.FlowModel;
import org.springframework.webflow.engine.model.builder.FlowModelBuilder;
import org.springframework.webflow.engine.model.builder.FlowModelBuilderException;
import org.springframework.webflow.engine.model.registry.FlowModelHolder;

public class DefaultFlowModelHolder
implements FlowModelHolder {
    private FlowModel flowModel;
    private FlowModelBuilder flowModelBuilder;
    private boolean assembling;

    public DefaultFlowModelHolder(FlowModelBuilder flowModelBuilder) {
        Assert.notNull((Object)flowModelBuilder, (String)"The flow model builder is required");
        this.flowModelBuilder = flowModelBuilder;
    }

    public synchronized FlowModel getFlowModel() {
        if (this.assembling) {
            return this.flowModelBuilder.getFlowModel();
        }
        if (this.flowModel == null) {
            this.assembleFlowModel();
        } else if (this.flowModelBuilder.hasFlowModelResourceChanged()) {
            this.assembleFlowModel();
        }
        return this.flowModel;
    }

    public Resource getFlowModelResource() {
        return this.flowModelBuilder.getFlowModelResource();
    }

    public boolean hasFlowModelChanged() {
        return this.flowModelBuilder.hasFlowModelResourceChanged();
    }

    public synchronized void refresh() {
        this.assembleFlowModel();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void assembleFlowModel() throws FlowModelBuilderException {
        try {
            this.assembling = true;
            this.flowModelBuilder.init();
            this.flowModelBuilder.build();
            this.flowModel = this.flowModelBuilder.getFlowModel();
            Object var1_3 = null;
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            try {
                this.flowModelBuilder.dispose();
                Object var3_7 = null;
                this.assembling = false;
                throw throwable;
            }
            catch (Throwable throwable2) {
                Object var3_6 = null;
                this.assembling = false;
                throw throwable2;
            }
        }
        try {}
        catch (Throwable throwable) {
            Object var3_8 = null;
            this.assembling = false;
            throw throwable;
        }
        this.flowModelBuilder.dispose();
        Object var3_9 = null;
        this.assembling = false;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("flowModelBuilder", (Object)this.flowModelBuilder).toString();
    }
}

