/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.support;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.engine.ActionList;
import org.springframework.webflow.engine.FlowExecutionExceptionHandler;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.support.DefaultTargetStateResolver;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.RequestContext;

public class TransitionExecutingFlowExecutionExceptionHandler
implements FlowExecutionExceptionHandler {
    private static final Log logger;
    public static final String FLOW_EXECUTION_EXCEPTION_ATTRIBUTE = "flowExecutionException";
    public static final String ROOT_CAUSE_EXCEPTION_ATTRIBUTE = "rootCauseException";
    private Map exceptionTargetStateMappings = new HashMap();
    private ActionList actionList = new ActionList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.webflow.engine.support.TransitionExecutingFlowExecutionExceptionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    public TransitionExecutingFlowExecutionExceptionHandler add(Class exceptionClass, String targetStateId) {
        return this.add(exceptionClass, new DefaultTargetStateResolver(targetStateId));
    }

    public TransitionExecutingFlowExecutionExceptionHandler add(Class exceptionClass, TargetStateResolver targetStateResolver) {
        Assert.notNull((Object)exceptionClass, (String)"The exception class is required");
        Assert.notNull((Object)targetStateResolver, (String)"The target state resolver is required");
        this.exceptionTargetStateMappings.put(exceptionClass, targetStateResolver);
        return this;
    }

    public ActionList getActionList() {
        return this.actionList;
    }

    public boolean canHandle(FlowExecutionException e) {
        return this.getTargetStateResolver(e) != null;
    }

    public void handle(FlowExecutionException exception, RequestControlContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Handling flow execution exception " + exception), (Throwable)exception);
        }
        this.exposeException(context, exception, this.findRootCause(exception));
        this.actionList.execute(context);
        context.execute(new Transition(this.getTargetStateResolver(exception)));
    }

    protected void exposeException(RequestContext context, FlowExecutionException exception, Throwable rootCause) {
        context.getFlashScope().put(FLOW_EXECUTION_EXCEPTION_ATTRIBUTE, exception);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Exposing flow execution exception root cause " + rootCause + " under attribute '" + ROOT_CAUSE_EXCEPTION_ATTRIBUTE + "'"));
        }
        context.getFlashScope().put(ROOT_CAUSE_EXCEPTION_ATTRIBUTE, rootCause);
    }

    protected TargetStateResolver getTargetStateResolver(Throwable e) {
        if (this.isRootCause(e)) {
            return this.findTargetStateResolver(e.getClass());
        }
        TargetStateResolver targetStateResolver = (TargetStateResolver)this.exceptionTargetStateMappings.get(e.getClass());
        if (targetStateResolver != null) {
            return targetStateResolver;
        }
        return this.getTargetStateResolver(e.getCause());
    }

    private boolean isRootCause(Throwable t) {
        return t.getCause() == null;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TargetStateResolver findTargetStateResolver(Class exceptionType) {
        Class<?> clazz;
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                if (this.exceptionTargetStateMappings.containsKey(exceptionType)) {
                    return (TargetStateResolver)this.exceptionTargetStateMappings.get(exceptionType);
                }
                exceptionType = exceptionType.getSuperclass();
            }
            if (exceptionType == null) break;
            clazz = class$1;
            if (clazz != null) continue;
            try {
                clazz = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (exceptionType != clazz);
        return null;
    }

    private Throwable findRootCause(Throwable e) {
        Throwable cause = e.getCause();
        if (cause == null) {
            return e;
        }
        return this.findRootCause(cause);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("exceptionHandlingMappings", (Object)this.exceptionTargetStateMappings).toString();
    }
}

