/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import java.util.EnumSet;
import java.util.Iterator;
import javax.el.ValueExpression;
import javax.faces.application.ViewHandler;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.Lifecycle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.expression.Expression;
import org.springframework.faces.webflow.JsfRuntimeInformation;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.faces.webflow.JsfView;
import org.springframework.faces.webflow.PostRestoreStateEventVisitCallback;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;
import org.springframework.webflow.execution.ViewFactory;

public class JsfViewFactory
implements ViewFactory {
    private static String SKIP_ITERATION_HINT = "javax.faces.visit.SKIP_ITERATION";
    private static final Log logger = LogFactory.getLog(JsfViewFactory.class);
    private final Expression viewIdExpression;
    private final Lifecycle lifecycle;

    public JsfViewFactory(Expression viewIdExpression, Lifecycle lifecycle) {
        this.viewIdExpression = viewIdExpression;
        this.lifecycle = lifecycle;
    }

    public View getView(RequestContext context) {
        boolean notifyPhaseListeners;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Assert.state((facesContext != null ? 1 : 0) != 0, (String)"FacesContext has not been initialized within the current Web Flow request. Check the configuration for your <webflow:flow-executor>. For JSF you will need FlowFacesContextLifecycleListener configured as one of its flow execution listeners.");
        facesContext.setCurrentPhaseId(PhaseId.RESTORE_VIEW);
        boolean bl = notifyPhaseListeners = !facesContext.getRenderResponse();
        if (notifyPhaseListeners) {
            JsfUtils.notifyBeforeListeners(PhaseId.RESTORE_VIEW, this.lifecycle, facesContext);
        }
        UIViewRoot viewRoot = this.getViewRoot(context, facesContext);
        facesContext.setViewRoot(viewRoot);
        this.publishPostRestoreStateEvent(facesContext);
        if (notifyPhaseListeners) {
            JsfUtils.notifyAfterListeners(PhaseId.RESTORE_VIEW, this.lifecycle, facesContext);
        }
        return new JsfView(viewRoot, this.lifecycle, context);
    }

    private UIViewRoot getViewRoot(RequestContext context, FacesContext facesContext) {
        ViewHandler viewHandler = this.getViewHandler(facesContext);
        String viewName = (String)this.viewIdExpression.getValue((Object)context);
        if (this.viewAlreadySet(facesContext, viewName)) {
            return this.getViewRootForAlreadySetView(context, facesContext);
        }
        if (context.inViewState()) {
            return this.getViewStateViewRoot(context, facesContext, viewHandler, viewName);
        }
        return this.getTransientViewRoot(context, facesContext, viewHandler, viewName);
    }

    private ViewHandler getViewHandler(FacesContext facesContext) {
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        if (!JsfRuntimeInformation.isPortletRequest(facesContext)) {
            viewHandler.initView(facesContext);
        }
        return viewHandler;
    }

    private boolean viewAlreadySet(FacesContext facesContext, String viewName) {
        return facesContext.getViewRoot() != null && facesContext.getViewRoot().getViewId().equals(viewName);
    }

    private UIViewRoot getViewRootForAlreadySetView(RequestContext context, FacesContext facesContext) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Existing view root found with id '" + facesContext.getViewRoot().getId() + "'"));
        }
        UIViewRoot viewRoot = facesContext.getViewRoot();
        viewRoot.setLocale(context.getExternalContext().getLocale());
        this.processTree(facesContext, (UIComponent)viewRoot);
        return viewRoot;
    }

    private UIViewRoot getViewStateViewRoot(RequestContext context, FacesContext facesContext, ViewHandler viewHandler, String viewName) {
        UIViewRoot viewRoot = viewHandler.restoreView(facesContext, viewName);
        if (viewRoot != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("UIViewRoot restored for '" + viewName + "'"));
            }
            this.processTree(facesContext, (UIComponent)viewRoot);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating UIViewRoot from '" + viewName + "'"));
            }
            viewRoot = viewHandler.createView(facesContext, viewName);
        }
        return viewRoot;
    }

    private UIViewRoot getTransientViewRoot(RequestContext context, FacesContext facesContext, ViewHandler viewHandler, String viewName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating transient UIViewRoot from '" + viewName + "'"));
        }
        UIViewRoot viewRoot = viewHandler.createView(facesContext, viewName);
        viewRoot.setTransient(true);
        return viewRoot;
    }

    private void processTree(FacesContext context, UIComponent component) {
        ValueExpression binding;
        if (!context.getRenderResponse() && component instanceof EditableValueHolder) {
            ((EditableValueHolder)component).setValid(true);
        }
        if ((binding = component.getValueExpression("binding")) != null) {
            binding.setValue(context.getELContext(), (Object)component);
        }
        Iterator it = component.getFacetsAndChildren();
        while (it.hasNext()) {
            this.processTree(context, (UIComponent)it.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishPostRestoreStateEvent(FacesContext facesContext) {
        Object visitHint = null;
        try {
            Enum.valueOf(VisitHint.class, "SKIP_ITERATION");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            facesContext.getAttributes().put(SKIP_ITERATION_HINT, true);
            VisitContext visitContext = visitHint != null ? VisitContext.createVisitContext((FacesContext)facesContext, null, EnumSet.of(VisitHint.SKIP_ITERATION)) : VisitContext.createVisitContext((FacesContext)facesContext);
            facesContext.getViewRoot().visitTree(visitContext, (VisitCallback)new PostRestoreStateEventVisitCallback());
        }
        catch (AbortProcessingException e) {
            facesContext.getApplication().publishEvent(facesContext, ExceptionQueuedEvent.class, (Object)new ExceptionQueuedEventContext(facesContext, (Throwable)e, null, facesContext.getCurrentPhaseId()));
        }
        finally {
            facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
        }
    }
}

