/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import javax.faces.context.FacesContext;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.webflow.execution.RequestContext;

public class JsfRuntimeInformation {
    public static final int JSF_11 = 0;
    public static final int JSF_12 = 1;
    public static final int JSF_20 = 2;
    private static final int jsfVersion;
    private static final boolean myFacesPresent;

    static {
        myFacesPresent = ClassUtils.isPresent((String)"org.apache.myfaces.webapp.MyFacesServlet", (ClassLoader)JsfUtils.class.getClassLoader());
        jsfVersion = ReflectionUtils.findMethod(FacesContext.class, (String)"isPostback") != null ? 2 : (ReflectionUtils.findMethod(FacesContext.class, (String)"getELContext") != null ? 1 : 0);
    }

    public static boolean isAtLeastJsf20() {
        return jsfVersion >= 2;
    }

    public static boolean isAtLeastJsf12() {
        return jsfVersion >= 1;
    }

    public static boolean isLessThanJsf20() {
        return jsfVersion < 2;
    }

    public static boolean isMyFacesPresent() {
        return myFacesPresent;
    }

    public static boolean isPortletRequest(FacesContext context) {
        return context.getExternalContext().getContext().getClass().getName().indexOf("Portlet") != -1;
    }

    public static boolean isPortletRequest(RequestContext context) {
        return ClassUtils.getMethodIfAvailable(context.getExternalContext().getNativeContext().getClass(), (String)"getPortletContextName", (Class[])new Class[0]) != null;
    }

    public static boolean isPartialStateSavingSupported() {
        return JsfRuntimeInformation.isAtLeastJsf20() && !JsfRuntimeInformation.isMyFacesPresent();
    }
}

