/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import java.io.IOException;
import java.io.Serializable;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.lifecycle.Lifecycle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.faces.ui.AjaxViewRoot;
import org.springframework.faces.webflow.FlowFacesContext;
import org.springframework.faces.webflow.JsfRuntimeInformation;
import org.springframework.faces.webflow.ViewRootHolder;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;

public class JsfView
implements View {
    private static final Log logger = LogFactory.getLog(JsfView.class);
    public static final String EVENT_KEY = "org.springframework.webflow.FacesEvent";
    private UIViewRoot viewRoot;
    private Lifecycle facesLifecycle;
    private RequestContext requestContext;
    private String viewId;

    public JsfView(UIViewRoot viewRoot, Lifecycle facesLifecycle, RequestContext context) {
        this.viewRoot = viewRoot;
        this.viewId = viewRoot.getViewId();
        this.facesLifecycle = facesLifecycle;
        this.requestContext = context;
    }

    public UIViewRoot getViewRoot() {
        return this.viewRoot;
    }

    public void setViewRoot(UIViewRoot viewRoot) {
        this.viewRoot = viewRoot;
    }

    public void render() throws IOException {
        FacesContext facesContext = FlowFacesContext.getCurrentInstance();
        if (facesContext.getResponseComplete()) {
            return;
        }
        facesContext.setViewRoot(this.viewRoot);
        try {
            logger.debug((Object)"Asking faces lifecycle to render");
            this.facesLifecycle.render(facesContext);
            if (JsfRuntimeInformation.isAtLeastJsf20() && this.requestContext.getExternalContext().isAjaxRequest()) {
                this.saveState();
            }
        }
        finally {
            logger.debug((Object)"View rendering complete");
            facesContext.responseComplete();
        }
    }

    public boolean userEventQueued() {
        if (JsfRuntimeInformation.isAtLeastJsf12()) {
            return this.requestContext.getRequestParameters().contains("javax.faces.ViewState");
        }
        return this.requestContext.getRequestParameters().size() > 1;
    }

    public void processUserEvent() {
        FacesContext facesContext = FlowFacesContext.getCurrentInstance();
        facesContext.setViewRoot(this.viewRoot);
        if (!facesContext.getRenderResponse() && !facesContext.getResponseComplete()) {
            this.facesLifecycle.execute(facesContext);
        }
    }

    public void saveState() {
        FacesContext facesContext = FlowFacesContext.getCurrentInstance();
        if (this.viewRoot instanceof AjaxViewRoot) {
            facesContext.setViewRoot(((AjaxViewRoot)this.viewRoot).getOriginalViewRoot());
        } else {
            facesContext.setViewRoot(this.viewRoot);
        }
        facesContext.getApplication().getStateManager().saveSerializedView(facesContext);
    }

    public Serializable getUserEventState() {
        if (JsfRuntimeInformation.isLessThanJsf20()) {
            return new ViewRootHolder(this.getViewRoot());
        }
        logger.debug((Object)"User event state requested but not saved.");
        return null;
    }

    public boolean hasFlowEvent() {
        return this.requestContext.getExternalContext().getRequestMap().contains(EVENT_KEY);
    }

    public Event getFlowEvent() {
        return new Event((Object)this, this.getEventId());
    }

    public String toString() {
        return "[JSFView = '" + this.viewId + "']";
    }

    private String getEventId() {
        return (String)this.requestContext.getExternalContext().getRequestMap().get(EVENT_KEY);
    }
}

