/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import java.io.IOException;
import java.io.Serializable;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.lifecycle.Lifecycle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.faces.ui.AjaxViewRoot;
import org.springframework.faces.webflow.FlowFacesContext;
import org.springframework.faces.webflow.JsfRuntimeInformation;
import org.springframework.faces.webflow.ViewRootHolder;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;

public class JsfView
implements View {
    private static final Log logger = LogFactory.getLog(JsfView.class);
    public static final String EVENT_KEY = "org.springframework.webflow.FacesEvent";
    private UIViewRoot viewRoot;
    private Lifecycle facesLifecycle;
    private RequestContext requestContext;
    private String viewId;

    public JsfView(UIViewRoot viewRoot, Lifecycle facesLifecycle, RequestContext context) {
        this.viewRoot = viewRoot;
        this.viewId = viewRoot.getViewId();
        this.facesLifecycle = facesLifecycle;
        this.requestContext = context;
    }

    public UIViewRoot getViewRoot() {
        return this.viewRoot;
    }

    public void setViewRoot(UIViewRoot viewRoot) {
        this.viewRoot = viewRoot;
    }

    public void render() throws IOException {
        FlowFacesContext facesContext = FlowFacesContext.newInstance(this.requestContext, this.facesLifecycle);
        if (facesContext.getResponseComplete()) {
            return;
        }
        facesContext.setViewRoot(this.viewRoot);
        try {
            logger.debug((Object)"Asking faces lifecycle to render");
            this.facesLifecycle.render((FacesContext)facesContext);
        }
        finally {
            logger.debug((Object)"View rendering complete");
            facesContext.responseComplete();
            facesContext.release();
        }
    }

    public boolean userEventQueued() {
        if (JsfRuntimeInformation.isAtLeastJsf12()) {
            return this.requestContext.getRequestParameters().contains("javax.faces.ViewState");
        }
        return this.requestContext.getRequestParameters().size() > 1;
    }

    public void processUserEvent() {
        FlowFacesContext facesContext = FlowFacesContext.newInstance(this.requestContext, this.facesLifecycle);
        facesContext.setViewRoot(this.viewRoot);
        try {
            if (!facesContext.getRenderResponse() && !facesContext.getResponseComplete()) {
                this.facesLifecycle.execute((FacesContext)facesContext);
            }
        }
        finally {
            facesContext.release();
        }
    }

    public void saveState() {
        FlowFacesContext facesContext = FlowFacesContext.newInstance(this.requestContext, this.facesLifecycle);
        if (this.viewRoot instanceof AjaxViewRoot) {
            facesContext.setViewRoot(((AjaxViewRoot)this.viewRoot).getOriginalViewRoot());
        } else {
            facesContext.setViewRoot(this.viewRoot);
        }
        try {
            facesContext.getApplication().getStateManager().saveSerializedView((FacesContext)facesContext);
        }
        finally {
            facesContext.release();
        }
    }

    public Serializable getUserEventState() {
        return new ViewRootHolder(this.getViewRoot());
    }

    public boolean hasFlowEvent() {
        return this.requestContext.getExternalContext().getRequestMap().contains(EVENT_KEY);
    }

    public Event getFlowEvent() {
        return new Event((Object)this, this.getEventId());
    }

    public String toString() {
        return "[JSFView = '" + this.viewId + "']";
    }

    private String getEventId() {
        return (String)this.requestContext.getExternalContext().getRequestMap().get(EVENT_KEY);
    }
}

