/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import com.sun.faces.facelets.impl.DefaultResourceResolver;
import java.io.IOException;
import java.net.URL;
import javax.faces.FacesException;
import javax.faces.view.facelets.ResourceResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class FlowResourceResolver
extends ResourceResolver {
    ResourceResolver delegateResolver = new DefaultResourceResolver();

    public URL resolveUrl(String path) {
        if (!JsfUtils.isFlowRequest()) {
            return this.delegateResolver.resolveUrl(path);
        }
        try {
            RequestContext context = RequestContextHolder.getRequestContext();
            ApplicationContext flowContext = context.getActiveFlow().getApplicationContext();
            if (flowContext == null) {
                throw new IllegalStateException("A Flow ApplicationContext is required to resolve Flow View Resources");
            }
            ApplicationContext appContext = flowContext.getParent();
            Resource viewResource = appContext.getResource(path);
            if (viewResource.exists()) {
                return viewResource.getURL();
            }
            return this.delegateResolver.resolveUrl(path);
        }
        catch (IOException ex) {
            throw new FacesException((Throwable)ex);
        }
    }
}

