/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.RenderKit;
import org.springframework.faces.webflow.ExternalContextWrapper;
import org.springframework.faces.webflow.FlowFacesContextMessageDelegate;
import org.springframework.util.ClassUtils;
import org.springframework.webflow.execution.RequestContext;

public class FlowFacesContext
extends FacesContext {
    static final String RENDER_RESPONSE_KEY = "flowRenderResponse";
    private RequestContext context;
    private FlowFacesContextMessageDelegate messageDelegate;
    private FacesContext delegate;

    public static FlowFacesContext newInstance(RequestContext context, Lifecycle lifecycle) {
        FacesContextFactory facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        FacesContext defaultFacesContext = facesContextFactory.getFacesContext(context.getExternalContext().getNativeContext(), context.getExternalContext().getNativeRequest(), context.getExternalContext().getNativeResponse(), lifecycle);
        return new FlowFacesContext(context, defaultFacesContext);
    }

    public FlowFacesContext(RequestContext context, FacesContext delegate) {
        this.context = context;
        this.delegate = delegate;
        this.messageDelegate = new FlowFacesContextMessageDelegate(context);
        FlowFacesContext.setCurrentInstance((FacesContext)this);
    }

    public void addMessage(String clientId, FacesMessage message) {
        this.messageDelegate.addMessage(clientId, message);
    }

    public Iterator getClientIdsWithMessages() {
        return this.messageDelegate.getClientIdsWithMessages();
    }

    public ELContext getELContext() {
        Method delegateMethod = ClassUtils.getMethodIfAvailable(this.delegate.getClass(), (String)"getELContext", null);
        if (delegateMethod != null) {
            try {
                ELContext context = (ELContext)delegateMethod.invoke((Object)this.delegate, null);
                context.putContext(FacesContext.class, (Object)this);
                return context;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public FacesMessage.Severity getMaximumSeverity() {
        return this.messageDelegate.getMaximumSeverity();
    }

    public Iterator getMessages() {
        return this.messageDelegate.getMessages();
    }

    public Iterator getMessages(String clientId) {
        return this.messageDelegate.getMessages(clientId);
    }

    public boolean getRenderResponse() {
        Boolean renderResponse = this.context.getFlashScope().getBoolean(RENDER_RESPONSE_KEY);
        if (renderResponse == null) {
            return false;
        }
        return renderResponse;
    }

    public boolean getResponseComplete() {
        return this.context.getExternalContext().isResponseComplete();
    }

    public void renderResponse() {
        this.context.getFlashScope().put(RENDER_RESPONSE_KEY, (Object)Boolean.TRUE);
    }

    public void responseComplete() {
        this.context.getExternalContext().recordResponseComplete();
    }

    public Application getApplication() {
        return this.delegate.getApplication();
    }

    public ExternalContext getExternalContext() {
        return new FlowExternalContext(this.delegate.getExternalContext());
    }

    public RenderKit getRenderKit() {
        return this.delegate.getRenderKit();
    }

    public ResponseStream getResponseStream() {
        return this.delegate.getResponseStream();
    }

    public ResponseWriter getResponseWriter() {
        return this.delegate.getResponseWriter();
    }

    public UIViewRoot getViewRoot() {
        return this.delegate.getViewRoot();
    }

    public void release() {
        this.delegate.release();
        FlowFacesContext.setCurrentInstance(null);
    }

    public void setResponseStream(ResponseStream responseStream) {
        this.delegate.setResponseStream(responseStream);
    }

    public void setResponseWriter(ResponseWriter responseWriter) {
        this.delegate.setResponseWriter(responseWriter);
    }

    public void setViewRoot(UIViewRoot root) {
        this.delegate.setViewRoot(root);
    }

    protected FacesContext getDelegate() {
        return this.delegate;
    }

    public Map getAttributes() {
        return this.delegate.getAttributes();
    }

    public PartialViewContext getPartialViewContext() {
        return this.delegate.getPartialViewContext();
    }

    public List getMessageList() {
        return this.delegate.getMessageList();
    }

    public List getMessageList(String clientId) {
        return this.delegate.getMessageList(clientId);
    }

    public boolean isPostback() {
        return this.delegate.isPostback();
    }

    public PhaseId getCurrentPhaseId() {
        return this.delegate.getCurrentPhaseId();
    }

    public void setCurrentPhaseId(PhaseId currentPhaseId) {
        this.delegate.setCurrentPhaseId(currentPhaseId);
    }

    public ExceptionHandler getExceptionHandler() {
        return this.delegate.getExceptionHandler();
    }

    public boolean isProcessingEvents() {
        return this.delegate.isProcessingEvents();
    }

    public boolean isProjectStage(ProjectStage stage) {
        return this.delegate.isProjectStage(stage);
    }

    public boolean isValidationFailed() {
        return this.delegate.isValidationFailed();
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.delegate.setExceptionHandler(exceptionHandler);
    }

    public void setProcessingEvents(boolean processingEvents) {
        this.delegate.setProcessingEvents(processingEvents);
    }

    public void validationFailed() {
        this.delegate.validationFailed();
    }

    private class FlowExternalContext
    extends ExternalContextWrapper {
        private static final String CUSTOM_RESPONSE = "customResponse";

        public FlowExternalContext(ExternalContext delegate) {
            super(delegate);
        }

        public Object getResponse() {
            if (FlowFacesContext.this.context.getRequestScope().contains(CUSTOM_RESPONSE)) {
                return FlowFacesContext.this.context.getRequestScope().get(CUSTOM_RESPONSE);
            }
            return this.delegate.getResponse();
        }

        public void setResponse(Object response) {
            FlowFacesContext.this.context.getRequestScope().put(CUSTOM_RESPONSE, response);
            this.delegate.setResponse(response);
        }
    }
}

