/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.ui;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.springframework.beans.BeanUtils;
import org.springframework.faces.ui.HTML;
import org.springframework.faces.ui.ProgressiveCommandButtonRenderer;
import org.springframework.faces.ui.ProgressiveUICommand;
import org.springframework.faces.ui.RenderAttributeCallback;
import org.springframework.faces.ui.RendererUtils;
import org.springframework.faces.ui.resource.ResourceHelper;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.util.Assert;

public class ProgressiveCommandLinkRenderer
extends ProgressiveCommandButtonRenderer {
    private static String[] ATTRIBUTES_TO_RENDER;
    private static String ANCHOR_TAG_NAME;
    private Map attributeCallbacks;
    private RenderAttributeCallback hrefCallback = new RenderAttributeCallback(){

        public void doRender(FacesContext context, ResponseWriter writer, UIComponent component, String attribute, Object attributeValue, String property) throws IOException {
            writer.writeAttribute(attribute, (Object)"#", property);
        }
    };
    private RenderAttributeCallback classCallback = new RenderAttributeCallback(){

        public void doRender(FacesContext context, ResponseWriter writer, UIComponent component, String attribute, Object attributeValue, String property) throws IOException {
            String classToAdd = "progressiveLink";
            attributeValue = attributeValue != null ? String.valueOf(attributeValue.toString()) + " " + classToAdd : classToAdd;
            writer.writeAttribute(attribute, attributeValue, property);
        }
    };
    private RenderAttributeCallback noOpCallback = new RenderAttributeCallback(){

        public void doRender(FacesContext context, ResponseWriter writer, UIComponent component, String attribute, Object attributeValue, String property) throws IOException {
        }
    };

    static {
        ANCHOR_TAG_NAME = "a";
        ArrayList tempList = new ArrayList();
        tempList.addAll(Arrays.asList(HTML.STANDARD_ATTRIBUTES));
        tempList.addAll(Arrays.asList(HTML.ANCHOR_ATTRIBUTES));
        tempList.addAll(Arrays.asList(HTML.COMMON_ELEMENT_EVENTS));
        tempList.addAll(Arrays.asList(HTML.KEYBOARD_EVENTS));
        tempList.addAll(Arrays.asList(HTML.MOUSE_EVENTS));
        ATTRIBUTES_TO_RENDER = new String[tempList.size()];
        ListIterator i = tempList.listIterator();
        while (i.hasNext()) {
            ProgressiveCommandLinkRenderer.ATTRIBUTES_TO_RENDER[i.nextIndex()] = (String)i.next();
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!JsfUtils.isAsynchronousFlowRequest()) {
            ProgressiveUICommand button = new ProgressiveUICommand();
            button.getAttributes().putAll(component.getAttributes());
            BeanUtils.copyProperties((Object)component, (Object)((Object)button));
            button.setRendererType("spring.faces.ProgressiveCommandButtonRenderer");
            button.setAjaxEnabled(Boolean.FALSE);
            button.encodeBegin(context);
            button.encodeChildren(context);
            button.encodeEnd(context);
            ResourceHelper.beginScriptBlock(context);
            ResponseWriter writer = context.getResponseWriter();
            String scriptVarStart = "var " + component.getClientId(context).replaceAll(":", "_") + "_link = \"";
            writer.writeText((Object)scriptVarStart, null);
            writer = new DoubleQuoteEscapingWriter(writer);
            context.setResponseWriter(writer);
        }
        super.encodeBegin(context, component);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String valueAttr = "value";
        if (component.getAttributes().get(valueAttr) != null) {
            writer.writeText(component.getAttributes().get(valueAttr), valueAttr);
        }
        super.encodeChildren(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        StringBuffer decorationParams = new StringBuffer();
        decorationParams.append("{");
        decorationParams.append("elementId : '" + component.getClientId(context) + "'");
        ResponseWriter writer = context.getResponseWriter();
        if (!JsfUtils.isAsynchronousFlowRequest()) {
            DoubleQuoteEscapingWriter tempWriter = (DoubleQuoteEscapingWriter)writer;
            String scriptVarValue = tempWriter.escapeResult();
            context.setResponseWriter(tempWriter.original);
            writer = tempWriter.original;
            writer.writeText((Object)scriptVarValue, null);
            String scriptVarEnd = "\";\n";
            writer.writeText((Object)scriptVarEnd, null);
            decorationParams.append(", linkHtml : " + component.getClientId(context).replaceAll(":", "_") + "_link");
            ResourceHelper.endScriptBlock(context);
        }
        decorationParams.append("}");
        StringBuffer advisorScript = new StringBuffer();
        advisorScript.append("Spring.addDecoration(new Spring.CommandLinkDecoration(" + decorationParams.toString() + "));");
        ResourceHelper.beginScriptBlock(context);
        writer.writeText((Object)advisorScript, null);
        ResourceHelper.endScriptBlock(context);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected String[] getAttributesToRender(UIComponent component) {
        return ATTRIBUTES_TO_RENDER;
    }

    protected String getRenderedTagName(UIComponent component) {
        return ANCHOR_TAG_NAME;
    }

    protected Map getAttributeCallbacks(UIComponent component) {
        if (this.attributeCallbacks == null) {
            this.attributeCallbacks = new HashMap();
            this.attributeCallbacks.putAll(super.getAttributeCallbacks(component));
            this.attributeCallbacks.put("href", this.hrefCallback);
            this.attributeCallbacks.put("class", this.classCallback);
            this.attributeCallbacks.put("type", this.noOpCallback);
        }
        return this.attributeCallbacks;
    }

    protected String getOnClickNoAjax(FacesContext context, UIComponent component) {
        String params = this.encodeParamsAsArray(context, component);
        StringBuffer onclick = new StringBuffer();
        onclick.append("this.submitFormFromLink('" + RendererUtils.getFormId(context, component) + "','" + component.getClientId(context) + "', " + params + "); return false;");
        return onclick.toString();
    }

    protected String encodeParamsAsArray(FacesContext context, UIComponent component) {
        StringBuffer paramArray = new StringBuffer();
        paramArray.append("[");
        int i = 0;
        while (i < component.getChildCount()) {
            if (component.getChildren().get(i) instanceof UIParameter) {
                UIParameter param = (UIParameter)component.getChildren().get(i);
                Assert.hasText((String)param.getName(), (String)"UIParameter requires a name when used as a child of a UICommand component");
                if (paramArray.length() > 1) {
                    paramArray.append(", ");
                }
                paramArray.append("{name : '" + param.getName() + "'");
                paramArray.append(", value : '" + param.getValue() + "'}");
            }
            ++i;
        }
        paramArray.append("]");
        return paramArray.toString();
    }

    private class DoubleQuoteEscapingWriter
    extends ResponseWriter {
        private ResponseWriter original;
        private ResponseWriter clonedWriter;
        private StringWriter buffer = new StringWriter();

        public DoubleQuoteEscapingWriter(ResponseWriter original) {
            this.original = original;
            this.clonedWriter = original.cloneWithWriter((Writer)this.buffer);
        }

        public String escapeResult() {
            String result = this.buffer.toString();
            result = result.replaceAll("\\\"", "\\\\\"");
            return result;
        }

        public ResponseWriter cloneWithWriter(Writer arg0) {
            return this.clonedWriter.cloneWithWriter(arg0);
        }

        public void endDocument() throws IOException {
            this.clonedWriter.endDocument();
        }

        public void endElement(String arg0) throws IOException {
            this.clonedWriter.endElement(arg0);
        }

        public void flush() throws IOException {
            this.clonedWriter.flush();
        }

        public String getCharacterEncoding() {
            return this.clonedWriter.getCharacterEncoding();
        }

        public String getContentType() {
            return this.clonedWriter.getContentType();
        }

        public void startDocument() throws IOException {
            this.clonedWriter.startDocument();
        }

        public void startElement(String arg0, UIComponent arg1) throws IOException {
            this.clonedWriter.startElement(arg0, arg1);
        }

        public void writeAttribute(String arg0, Object arg1, String arg2) throws IOException {
            this.clonedWriter.writeAttribute(arg0, arg1, arg2);
        }

        public void writeComment(Object arg0) throws IOException {
            this.clonedWriter.writeComment(arg0);
        }

        public void writeText(char[] arg0, int arg1, int arg2) throws IOException {
            this.clonedWriter.writeText(arg0, arg1, arg2);
        }

        public void writeText(Object arg0, String arg1) throws IOException {
            this.clonedWriter.writeText(arg0, arg1);
        }

        public void writeURIAttribute(String arg0, Object arg1, String arg2) throws IOException {
            this.clonedWriter.writeURIAttribute(arg0, arg1, arg2);
        }

        public void close() throws IOException {
            this.clonedWriter.close();
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            this.clonedWriter.write(cbuf, off, len);
        }
    }
}

