/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.ui;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.faces.ui.HTML;
import org.springframework.faces.ui.RenderAttributeCallback;

abstract class BaseHtmlTagRenderer
extends Renderer {
    protected Log log = LogFactory.getLog(BaseHtmlTagRenderer.class);
    private RenderAttributeCallback defaultRenderAttributeCallback = new RenderAttributeCallback(){

        public void doRender(FacesContext context, ResponseWriter writer, UIComponent component, String attribute, Object attributeValue, String property) throws IOException {
            if (attributeValue != null) {
                writer.writeAttribute(attribute, attributeValue, property);
            }
        }
    };

    BaseHtmlTagRenderer() {
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement(this.getRenderedTagName(null), component);
        this.writeAttributes(context, component);
    }

    protected void writeAttributes(FacesContext context, UIComponent component) throws IOException {
        int i = 0;
        while (i < this.getAttributesToRender(component).length) {
            try {
                String attribute;
                String property = attribute = this.getAttributesToRender(component)[i];
                if (this.getAttributeAliases(component).containsKey(attribute)) {
                    property = (String)this.getAttributeAliases(component).get(attribute);
                }
                Object attributeValue = component.getAttributes().get(property);
                RenderAttributeCallback callback = this.defaultRenderAttributeCallback;
                if (this.getAttributeCallbacks(null).containsKey(attribute)) {
                    callback = (RenderAttributeCallback)this.getAttributeCallbacks(component).get(attribute);
                }
                callback.doRender(context, context.getResponseWriter(), component, attribute, attributeValue, property);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            ++i;
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement(this.getRenderedTagName(null));
    }

    protected abstract String getRenderedTagName(UIComponent var1);

    protected abstract String[] getAttributesToRender(UIComponent var1);

    protected Map getAttributeAliases(UIComponent component) {
        return HTML.STANDARD_ATTRIBUTE_ALIASES;
    }

    protected Map getAttributeCallbacks(UIComponent component) {
        return Collections.EMPTY_MAP;
    }
}

