/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import java.io.IOException;
import javax.faces.application.StateManager;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.faces.webflow.FlowSerializedView;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.faces.webflow.TreeStructureManager;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class FlowViewStateManager
extends StateManager {
    private static final Log logger;
    private static final String SERIALIZED_VIEW_STATE = "flowSerializedViewState";
    private StateManager delegate;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.faces.webflow.FlowViewStateManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    public FlowViewStateManager(StateManager delegate) {
        this.delegate = delegate;
    }

    protected Object getComponentStateToSave(FacesContext context) {
        if (!JsfUtils.isFlowRequest()) {
            return super.getComponentStateToSave(context);
        }
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            return null;
        }
        return viewRoot.processSaveState(context);
    }

    protected Object getTreeStructureToSave(FacesContext context) {
        if (!JsfUtils.isFlowRequest()) {
            return super.getTreeStructureToSave(context);
        }
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            return null;
        }
        return new TreeStructureManager().buildTreeStructureToSave(viewRoot);
    }

    protected void restoreComponentState(FacesContext context, UIViewRoot viewRoot, String renderKitId) {
        if (!JsfUtils.isFlowRequest()) {
            super.restoreComponentState(context, viewRoot, renderKitId);
            return;
        }
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        FlowSerializedView view = (FlowSerializedView)requestContext.getViewScope().get(SERIALIZED_VIEW_STATE);
        viewRoot.processRestoreState(context, view.getComponentState());
        logger.debug((Object)"UIViewRoot component state restored");
    }

    protected UIViewRoot restoreTreeStructure(FacesContext context, String viewId, String renderKitId) {
        if (!JsfUtils.isFlowRequest()) {
            return super.restoreTreeStructure(context, viewId, renderKitId);
        }
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        FlowSerializedView view = (FlowSerializedView)requestContext.getViewScope().get(SERIALIZED_VIEW_STATE);
        if (view == null || !view.getViewId().equals(viewId)) {
            logger.debug((Object)"No matching view in view scope");
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Restoring view root with id '" + viewId + "' from view scope"));
        }
        if (view.getTreeStructure() == null) {
            logger.debug((Object)"Tree structure is null indicating transient UIViewRoot; returning null");
            return null;
        }
        UIViewRoot viewRoot = new TreeStructureManager().restoreTreeStructure(view.getTreeStructure());
        logger.debug((Object)"UIViewRoot structure restored");
        return viewRoot;
    }

    public void writeState(FacesContext context, StateManager.SerializedView state) throws IOException {
        this.delegate.writeState(context, state);
    }

    public boolean isSavingStateInClient(FacesContext context) {
        if (!JsfUtils.isFlowRequest()) {
            return this.delegate.isSavingStateInClient(context);
        }
        return false;
    }

    public StateManager.SerializedView saveSerializedView(FacesContext context) {
        if (context.getViewRoot().isTransient()) {
            return null;
        }
        if (!JsfUtils.isFlowRequest()) {
            return this.delegate.saveSerializedView(context);
        }
        FlowSerializedView view = (FlowSerializedView)this.saveView(context);
        return new StateManager.SerializedView((StateManager)this, view.getTreeStructure(), view.getComponentState());
    }

    public Object saveView(FacesContext context) {
        if (context.getViewRoot().isTransient()) {
            return null;
        }
        if (!JsfUtils.isFlowRequest()) {
            return this.delegate.saveView(context);
        }
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Saving view root '" + context.getViewRoot().getViewId() + "' in view scope"));
        }
        FlowSerializedView view = new FlowSerializedView(context.getViewRoot().getViewId(), this.getTreeStructureToSave(context), this.getComponentStateToSave(context));
        requestContext.getViewScope().put(SERIALIZED_VIEW_STATE, (Object)view);
        return view;
    }

    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        if (!JsfUtils.isFlowRequest()) {
            return this.delegate.restoreView(context, viewId, renderKitId);
        }
        UIViewRoot viewRoot = this.restoreTreeStructure(context, viewId, renderKitId);
        if (viewRoot != null) {
            this.restoreComponentState(context, viewRoot, renderKitId);
        }
        return viewRoot;
    }
}

