/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.mvc;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.util.Assert;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class JsfView
extends AbstractUrlBasedView {
    private Lifecycle facesLifecycle;

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.facesLifecycle = this.createFacesLifecycle();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FacesContext facesContext = this.createFacesContext(request, response);
        this.populateRequestMap(facesContext, model);
        JsfUtils.notifyBeforeListeners(PhaseId.RESTORE_VIEW, this.facesLifecycle, facesContext);
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        if (JsfUtils.isAtLeastJsf12() && !JsfUtils.isPortlet(facesContext)) {
            viewHandler.initView(facesContext);
        }
        UIViewRoot viewRoot = viewHandler.createView(facesContext, this.getUrl());
        Assert.notNull((Object)viewRoot, (String)("A JSF view could not be created for " + this.getUrl()));
        viewRoot.setLocale(RequestContextUtils.getLocale((HttpServletRequest)request));
        viewRoot.setTransient(true);
        facesContext.setViewRoot(viewRoot);
        JsfUtils.notifyAfterListeners(PhaseId.RESTORE_VIEW, this.facesLifecycle, facesContext);
        facesContext.setViewRoot(viewRoot);
        facesContext.renderResponse();
        try {
            try {
                JsfUtils.notifyBeforeListeners(PhaseId.RENDER_RESPONSE, this.facesLifecycle, facesContext);
                this.logger.debug((Object)"Asking view handler to render view");
                facesContext.getApplication().getViewHandler().renderView(facesContext, viewRoot);
                JsfUtils.notifyAfterListeners(PhaseId.RENDER_RESPONSE, this.facesLifecycle, facesContext);
            }
            catch (IOException e) {
                throw new FacesException("An I/O error occurred during view rendering", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.logger.debug((Object)"View rendering complete");
            facesContext.responseComplete();
            facesContext.release();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        this.logger.debug((Object)"View rendering complete");
        facesContext.responseComplete();
        facesContext.release();
    }

    private void populateRequestMap(FacesContext facesContext, Map model) {
        Iterator i = model.keySet().iterator();
        while (i.hasNext()) {
            String key = i.next().toString();
            facesContext.getExternalContext().getRequestMap().put(key, model.get(key));
        }
    }

    private FacesContext createFacesContext(HttpServletRequest request, HttpServletResponse response) {
        FacesContextFactory facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        return facesContextFactory.getFacesContext((Object)this.getServletContext(), (Object)request, (Object)response, this.facesLifecycle);
    }

    private Lifecycle createFacesLifecycle() {
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        return lifecycleFactory.getLifecycle("DEFAULT");
    }
}

