/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import java.io.IOException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.Lifecycle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.faces.ui.AjaxViewRoot;
import org.springframework.faces.webflow.FlowFacesContext;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.faces.webflow.ViewRootHolder;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;

public class JsfView
implements View {
    private static final Log logger;
    public static final String EVENT_KEY = "org.springframework.webflow.FacesEvent";
    private UIViewRoot viewRoot;
    private Lifecycle facesLifecycle;
    private RequestContext requestContext;
    private String viewId;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.faces.webflow.JsfView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    public JsfView(UIViewRoot viewRoot, Lifecycle facesLifecycle, RequestContext context) {
        this.viewRoot = viewRoot;
        this.viewId = viewRoot.getViewId();
        this.facesLifecycle = facesLifecycle;
        this.requestContext = context;
    }

    public UIViewRoot getViewRoot() {
        return this.viewRoot;
    }

    public void setViewRoot(UIViewRoot viewRoot) {
        this.viewRoot = viewRoot;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void render() throws IOException {
        FlowFacesContext facesContext = FlowFacesContext.newInstance(this.requestContext, this.facesLifecycle);
        if (facesContext.getResponseComplete()) {
            return;
        }
        facesContext.setViewRoot(this.viewRoot);
        try {
            JsfUtils.notifyBeforeListeners(PhaseId.RENDER_RESPONSE, this.facesLifecycle, facesContext);
            logger.debug((Object)"Asking view handler to render view");
            facesContext.getApplication().getViewHandler().renderView((FacesContext)facesContext, this.viewRoot);
            JsfUtils.notifyAfterListeners(PhaseId.RENDER_RESPONSE, this.facesLifecycle, facesContext);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            logger.debug((Object)"View rendering complete");
            facesContext.responseComplete();
            facesContext.release();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        logger.debug((Object)"View rendering complete");
        facesContext.responseComplete();
        facesContext.release();
    }

    public boolean userEventQueued() {
        return this.requestContext.getRequestParameters().size() > 1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processUserEvent() {
        FlowFacesContext facesContext = FlowFacesContext.newInstance(this.requestContext, this.facesLifecycle);
        facesContext.setViewRoot(this.viewRoot);
        try {
            if (!facesContext.getRenderResponse() && !facesContext.getResponseComplete()) {
                this.facesLifecycle.execute((FacesContext)facesContext);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            facesContext.release();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        facesContext.release();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveState() {
        FlowFacesContext facesContext = FlowFacesContext.newInstance(this.requestContext, this.facesLifecycle);
        if (this.viewRoot instanceof AjaxViewRoot) {
            facesContext.setViewRoot(((AjaxViewRoot)this.viewRoot).getOriginalViewRoot());
        } else {
            facesContext.setViewRoot(this.viewRoot);
        }
        try {
            facesContext.getApplication().getStateManager().saveView((FacesContext)facesContext);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            facesContext.release();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        facesContext.release();
    }

    public Object getUserEventState() {
        return new ViewRootHolder(this.getViewRoot());
    }

    public boolean hasFlowEvent() {
        return this.requestContext.getExternalContext().getRequestMap().contains(EVENT_KEY);
    }

    public Event getFlowEvent() {
        return new Event((Object)this, this.getEventId());
    }

    public String toString() {
        return "[JSFView = '" + this.viewId + "']";
    }

    private String getEventId() {
        return (String)this.requestContext.getExternalContext().getRequestMap().get(EVENT_KEY);
    }
}

